/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutResourceLogLevelRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, PutResourceLogLevelRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(PutResourceLogLevelRequest.getter(PutResourceLogLevelRequest::resourceIdentifier)).setter(PutResourceLogLevelRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(PutResourceLogLevelRequest.getter(PutResourceLogLevelRequest::resourceType)).setter(PutResourceLogLevelRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(PutResourceLogLevelRequest.getter(PutResourceLogLevelRequest::logLevelAsString)).setter(PutResourceLogLevelRequest.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD, LOG_LEVEL_FIELD));
    private final String resourceIdentifier;
    private final String resourceType;
    private final String logLevel;

    private PutResourceLogLevelRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceType = builder.resourceType;
        this.logLevel = builder.logLevel;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourceLogLevelRequest)) {
            return false;
        }
        PutResourceLogLevelRequest other = (PutResourceLogLevelRequest)((Object)obj);
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutResourceLogLevelRequest").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ResourceType", (Object)this.resourceType()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourceLogLevelRequest, T> g) {
        return obj -> g.apply((PutResourceLogLevelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private String resourceType;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourceLogLevelRequest model) {
            super(model);
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceType(model.resourceType);
            this.logLevel(model.logLevel);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        @Transient
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        @Transient
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourceLogLevelRequest build() {
            return new PutResourceLogLevelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutResourceLogLevelRequest> {
        public Builder resourceIdentifier(String var1);

        public Builder resourceType(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

