/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SigningAlg {
    ED25519("Ed25519"),
    P256_R1("P256r1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SigningAlg> VALUE_MAP;
    private final String value;

    private SigningAlg(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SigningAlg fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SigningAlg> knownValues() {
        EnumSet<SigningAlg> knownValues = EnumSet.allOf(SigningAlg.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SigningAlg.class, SigningAlg::toString);
    }
}

