/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.BatteryLevel;
import software.amazon.awssdk.services.iotwireless.model.DeviceState;
import software.amazon.awssdk.services.iotwireless.model.Event;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SidewalkDeviceMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SidewalkDeviceMetadata> {
    private static final SdkField<Integer> RSSI_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Rssi").getter(SidewalkDeviceMetadata.getter(SidewalkDeviceMetadata::rssi)).setter(SidewalkDeviceMetadata.setter(Builder::rssi)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rssi").build()}).build();
    private static final SdkField<String> BATTERY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatteryLevel").getter(SidewalkDeviceMetadata.getter(SidewalkDeviceMetadata::batteryLevelAsString)).setter(SidewalkDeviceMetadata.setter(Builder::batteryLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatteryLevel").build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Event").getter(SidewalkDeviceMetadata.getter(SidewalkDeviceMetadata::eventAsString)).setter(SidewalkDeviceMetadata.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()}).build();
    private static final SdkField<String> DEVICE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceState").getter(SidewalkDeviceMetadata.getter(SidewalkDeviceMetadata::deviceStateAsString)).setter(SidewalkDeviceMetadata.setter(Builder::deviceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RSSI_FIELD, BATTERY_LEVEL_FIELD, EVENT_FIELD, DEVICE_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer rssi;
    private final String batteryLevel;
    private final String event;
    private final String deviceState;

    private SidewalkDeviceMetadata(BuilderImpl builder) {
        this.rssi = builder.rssi;
        this.batteryLevel = builder.batteryLevel;
        this.event = builder.event;
        this.deviceState = builder.deviceState;
    }

    public final Integer rssi() {
        return this.rssi;
    }

    public final BatteryLevel batteryLevel() {
        return BatteryLevel.fromValue(this.batteryLevel);
    }

    public final String batteryLevelAsString() {
        return this.batteryLevel;
    }

    public final Event event() {
        return Event.fromValue(this.event);
    }

    public final String eventAsString() {
        return this.event;
    }

    public final DeviceState deviceState() {
        return DeviceState.fromValue(this.deviceState);
    }

    public final String deviceStateAsString() {
        return this.deviceState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rssi());
        hashCode = 31 * hashCode + Objects.hashCode(this.batteryLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkDeviceMetadata)) {
            return false;
        }
        SidewalkDeviceMetadata other = (SidewalkDeviceMetadata)obj;
        return Objects.equals(this.rssi(), other.rssi()) && Objects.equals(this.batteryLevelAsString(), other.batteryLevelAsString()) && Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.deviceStateAsString(), other.deviceStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SidewalkDeviceMetadata").add("Rssi", (Object)this.rssi()).add("BatteryLevel", (Object)this.batteryLevelAsString()).add("Event", (Object)this.eventAsString()).add("DeviceState", (Object)this.deviceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rssi": {
                return Optional.ofNullable(clazz.cast(this.rssi()));
            }
            case "BatteryLevel": {
                return Optional.ofNullable(clazz.cast(this.batteryLevelAsString()));
            }
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "DeviceState": {
                return Optional.ofNullable(clazz.cast(this.deviceStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkDeviceMetadata, T> g) {
        return obj -> g.apply((SidewalkDeviceMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer rssi;
        private String batteryLevel;
        private String event;
        private String deviceState;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkDeviceMetadata model) {
            this.rssi(model.rssi);
            this.batteryLevel(model.batteryLevel);
            this.event(model.event);
            this.deviceState(model.deviceState);
        }

        public final Integer getRssi() {
            return this.rssi;
        }

        public final void setRssi(Integer rssi) {
            this.rssi = rssi;
        }

        @Override
        @Transient
        public final Builder rssi(Integer rssi) {
            this.rssi = rssi;
            return this;
        }

        public final String getBatteryLevel() {
            return this.batteryLevel;
        }

        public final void setBatteryLevel(String batteryLevel) {
            this.batteryLevel = batteryLevel;
        }

        @Override
        @Transient
        public final Builder batteryLevel(String batteryLevel) {
            this.batteryLevel = batteryLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder batteryLevel(BatteryLevel batteryLevel) {
            this.batteryLevel(batteryLevel == null ? null : batteryLevel.toString());
            return this;
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        @Transient
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        @Transient
        public final Builder event(Event event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final String getDeviceState() {
            return this.deviceState;
        }

        public final void setDeviceState(String deviceState) {
            this.deviceState = deviceState;
        }

        @Override
        @Transient
        public final Builder deviceState(String deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceState(DeviceState deviceState) {
            this.deviceState(deviceState == null ? null : deviceState.toString());
            return this;
        }

        public SidewalkDeviceMetadata build() {
            return new SidewalkDeviceMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SidewalkDeviceMetadata> {
        public Builder rssi(Integer var1);

        public Builder batteryLevel(String var1);

        public Builder batteryLevel(BatteryLevel var1);

        public Builder event(String var1);

        public Builder event(Event var1);

        public Builder deviceState(String var1);

        public Builder deviceState(DeviceState var1);
    }
}

