/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Event {
    DISCOVERED("discovered"),
    LOST("lost"),
    ACK("ack"),
    NACK("nack"),
    PASSTHROUGH("passthrough"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Event> VALUE_MAP;
    private final String value;

    private Event(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Event fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Event> knownValues() {
        EnumSet<Event> knownValues = EnumSet.allOf(Event.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Event.class, Event::toString);
    }
}

