/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskCreate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWirelessGatewayTaskDefinitionRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, CreateWirelessGatewayTaskDefinitionRequest> {
    private static final SdkField<Boolean> AUTO_CREATE_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoCreateTasks").getter(CreateWirelessGatewayTaskDefinitionRequest.getter(CreateWirelessGatewayTaskDefinitionRequest::autoCreateTasks)).setter(CreateWirelessGatewayTaskDefinitionRequest.setter(Builder::autoCreateTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreateTasks").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateWirelessGatewayTaskDefinitionRequest.getter(CreateWirelessGatewayTaskDefinitionRequest::name)).setter(CreateWirelessGatewayTaskDefinitionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<UpdateWirelessGatewayTaskCreate> UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Update").getter(CreateWirelessGatewayTaskDefinitionRequest.getter(CreateWirelessGatewayTaskDefinitionRequest::update)).setter(CreateWirelessGatewayTaskDefinitionRequest.setter(Builder::update)).constructor(UpdateWirelessGatewayTaskCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Update").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateWirelessGatewayTaskDefinitionRequest.getter(CreateWirelessGatewayTaskDefinitionRequest::clientRequestToken)).setter(CreateWirelessGatewayTaskDefinitionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_CREATE_TASKS_FIELD, NAME_FIELD, UPDATE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final Boolean autoCreateTasks;
    private final String name;
    private final UpdateWirelessGatewayTaskCreate update;
    private final String clientRequestToken;

    private CreateWirelessGatewayTaskDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.autoCreateTasks = builder.autoCreateTasks;
        this.name = builder.name;
        this.update = builder.update;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final Boolean autoCreateTasks() {
        return this.autoCreateTasks;
    }

    public final String name() {
        return this.name;
    }

    public final UpdateWirelessGatewayTaskCreate update() {
        return this.update;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCreateTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.update());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWirelessGatewayTaskDefinitionRequest)) {
            return false;
        }
        CreateWirelessGatewayTaskDefinitionRequest other = (CreateWirelessGatewayTaskDefinitionRequest)((Object)obj);
        return Objects.equals(this.autoCreateTasks(), other.autoCreateTasks()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.update(), other.update()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWirelessGatewayTaskDefinitionRequest").add("AutoCreateTasks", (Object)this.autoCreateTasks()).add("Name", (Object)this.name()).add("Update", (Object)this.update()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoCreateTasks": {
                return Optional.ofNullable(clazz.cast(this.autoCreateTasks()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Update": {
                return Optional.ofNullable(clazz.cast(this.update()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWirelessGatewayTaskDefinitionRequest, T> g) {
        return obj -> g.apply((CreateWirelessGatewayTaskDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private Boolean autoCreateTasks;
        private String name;
        private UpdateWirelessGatewayTaskCreate update;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWirelessGatewayTaskDefinitionRequest model) {
            super(model);
            this.autoCreateTasks(model.autoCreateTasks);
            this.name(model.name);
            this.update(model.update);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final Boolean getAutoCreateTasks() {
            return this.autoCreateTasks;
        }

        @Override
        public final Builder autoCreateTasks(Boolean autoCreateTasks) {
            this.autoCreateTasks = autoCreateTasks;
            return this;
        }

        public final void setAutoCreateTasks(Boolean autoCreateTasks) {
            this.autoCreateTasks = autoCreateTasks;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final UpdateWirelessGatewayTaskCreate.Builder getUpdate() {
            return this.update != null ? this.update.toBuilder() : null;
        }

        @Override
        public final Builder update(UpdateWirelessGatewayTaskCreate update) {
            this.update = update;
            return this;
        }

        public final void setUpdate(UpdateWirelessGatewayTaskCreate.BuilderImpl update) {
            this.update = update != null ? update.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWirelessGatewayTaskDefinitionRequest build() {
            return new CreateWirelessGatewayTaskDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWirelessGatewayTaskDefinitionRequest> {
        public Builder autoCreateTasks(Boolean var1);

        public Builder name(String var1);

        public Builder update(UpdateWirelessGatewayTaskCreate var1);

        default public Builder update(Consumer<UpdateWirelessGatewayTaskCreate.Builder> update) {
            return this.update((UpdateWirelessGatewayTaskCreate)((UpdateWirelessGatewayTaskCreate.Builder)UpdateWirelessGatewayTaskCreate.builder().applyMutation(update)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

