/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SidewalkAccountInfoWithFingerprint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SidewalkAccountInfoWithFingerprint> {
    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmazonId").getter(SidewalkAccountInfoWithFingerprint.getter(SidewalkAccountInfoWithFingerprint::amazonId)).setter(SidewalkAccountInfoWithFingerprint.setter(Builder::amazonId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()}).build();
    private static final SdkField<String> FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Fingerprint").getter(SidewalkAccountInfoWithFingerprint.getter(SidewalkAccountInfoWithFingerprint::fingerprint)).setter(SidewalkAccountInfoWithFingerprint.setter(Builder::fingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fingerprint").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(SidewalkAccountInfoWithFingerprint.getter(SidewalkAccountInfoWithFingerprint::arn)).setter(SidewalkAccountInfoWithFingerprint.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_ID_FIELD, FINGERPRINT_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String amazonId;
    private final String fingerprint;
    private final String arn;

    private SidewalkAccountInfoWithFingerprint(BuilderImpl builder) {
        this.amazonId = builder.amazonId;
        this.fingerprint = builder.fingerprint;
        this.arn = builder.arn;
    }

    public final String amazonId() {
        return this.amazonId;
    }

    public final String fingerprint() {
        return this.fingerprint;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkAccountInfoWithFingerprint)) {
            return false;
        }
        SidewalkAccountInfoWithFingerprint other = (SidewalkAccountInfoWithFingerprint)obj;
        return Objects.equals(this.amazonId(), other.amazonId()) && Objects.equals(this.fingerprint(), other.fingerprint()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"SidewalkAccountInfoWithFingerprint").add("AmazonId", (Object)this.amazonId()).add("Fingerprint", (Object)(this.fingerprint() == null ? null : "*** Sensitive Data Redacted ***")).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonId": {
                return Optional.ofNullable(clazz.cast(this.amazonId()));
            }
            case "Fingerprint": {
                return Optional.ofNullable(clazz.cast(this.fingerprint()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkAccountInfoWithFingerprint, T> g) {
        return obj -> g.apply((SidewalkAccountInfoWithFingerprint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amazonId;
        private String fingerprint;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkAccountInfoWithFingerprint model) {
            this.amazonId(model.amazonId);
            this.fingerprint(model.fingerprint);
            this.arn(model.arn);
        }

        public final String getAmazonId() {
            return this.amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        public final String getFingerprint() {
            return this.fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public SidewalkAccountInfoWithFingerprint build() {
            return new SidewalkAccountInfoWithFingerprint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SidewalkAccountInfoWithFingerprint> {
        public Builder amazonId(String var1);

        public Builder fingerprint(String var1);

        public Builder arn(String var1);
    }
}

