/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWirelessGatewayTaskResponse extends IotWirelessResponse implements
        ToCopyableBuilder<CreateWirelessGatewayTaskResponse.Builder, CreateWirelessGatewayTaskResponse> {
    private static final SdkField<String> WIRELESS_GATEWAY_TASK_DEFINITION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WirelessGatewayTaskDefinitionId")
            .getter(getter(CreateWirelessGatewayTaskResponse::wirelessGatewayTaskDefinitionId))
            .setter(setter(Builder::wirelessGatewayTaskDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayTaskDefinitionId")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateWirelessGatewayTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WIRELESS_GATEWAY_TASK_DEFINITION_ID_FIELD, STATUS_FIELD));

    private final String wirelessGatewayTaskDefinitionId;

    private final String status;

    private CreateWirelessGatewayTaskResponse(BuilderImpl builder) {
        super(builder);
        this.wirelessGatewayTaskDefinitionId = builder.wirelessGatewayTaskDefinitionId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the WirelessGatewayTaskDefinition.
     * </p>
     * 
     * @return The ID of the WirelessGatewayTaskDefinition.
     */
    public final String wirelessGatewayTaskDefinitionId() {
        return wirelessGatewayTaskDefinitionId;
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WirelessGatewayTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see WirelessGatewayTaskStatus
     */
    public final WirelessGatewayTaskStatus status() {
        return WirelessGatewayTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WirelessGatewayTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see WirelessGatewayTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(wirelessGatewayTaskDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWirelessGatewayTaskResponse)) {
            return false;
        }
        CreateWirelessGatewayTaskResponse other = (CreateWirelessGatewayTaskResponse) obj;
        return Objects.equals(wirelessGatewayTaskDefinitionId(), other.wirelessGatewayTaskDefinitionId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWirelessGatewayTaskResponse")
                .add("WirelessGatewayTaskDefinitionId", wirelessGatewayTaskDefinitionId()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WirelessGatewayTaskDefinitionId":
            return Optional.ofNullable(clazz.cast(wirelessGatewayTaskDefinitionId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWirelessGatewayTaskResponse, T> g) {
        return obj -> g.apply((CreateWirelessGatewayTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWirelessGatewayTaskResponse> {
        /**
         * <p>
         * The ID of the WirelessGatewayTaskDefinition.
         * </p>
         * 
         * @param wirelessGatewayTaskDefinitionId
         *        The ID of the WirelessGatewayTaskDefinition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see WirelessGatewayTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see WirelessGatewayTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayTaskStatus
         */
        Builder status(WirelessGatewayTaskStatus status);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String wirelessGatewayTaskDefinitionId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWirelessGatewayTaskResponse model) {
            super(model);
            wirelessGatewayTaskDefinitionId(model.wirelessGatewayTaskDefinitionId);
            status(model.status);
        }

        public final String getWirelessGatewayTaskDefinitionId() {
            return wirelessGatewayTaskDefinitionId;
        }

        @Override
        public final Builder wirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId) {
            this.wirelessGatewayTaskDefinitionId = wirelessGatewayTaskDefinitionId;
            return this;
        }

        public final void setWirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId) {
            this.wirelessGatewayTaskDefinitionId = wirelessGatewayTaskDefinitionId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WirelessGatewayTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public CreateWirelessGatewayTaskResponse build() {
            return new CreateWirelessGatewayTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
