/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAwsAccountWithPartnerAccountRequest extends IotWirelessRequest implements
        ToCopyableBuilder<AssociateAwsAccountWithPartnerAccountRequest.Builder, AssociateAwsAccountWithPartnerAccountRequest> {
    private static final SdkField<SidewalkAccountInfo> SIDEWALK_FIELD = SdkField
            .<SidewalkAccountInfo> builder(MarshallingType.SDK_POJO).memberName("Sidewalk")
            .getter(getter(AssociateAwsAccountWithPartnerAccountRequest::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkAccountInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(AssociateAwsAccountWithPartnerAccountRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final SidewalkAccountInfo sidewalk;

    private final String clientRequestToken;

    private AssociateAwsAccountWithPartnerAccountRequest(BuilderImpl builder) {
        super(builder);
        this.sidewalk = builder.sidewalk;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The Sidewalk account credentials.
     * </p>
     * 
     * @return The Sidewalk account credentials.
     */
    public final SidewalkAccountInfo sidewalk() {
        return sidewalk;
    }

    /**
     * <p>
     * Each resource must have a unique client request token. If you try to create a new resource with the same token as
     * a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate
     * a unique client request.
     * </p>
     * 
     * @return Each resource must have a unique client request token. If you try to create a new resource with the same
     *         token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will
     *         automatically generate a unique client request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAwsAccountWithPartnerAccountRequest)) {
            return false;
        }
        AssociateAwsAccountWithPartnerAccountRequest other = (AssociateAwsAccountWithPartnerAccountRequest) obj;
        return Objects.equals(sidewalk(), other.sidewalk()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAwsAccountWithPartnerAccountRequest").add("Sidewalk", sidewalk())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAwsAccountWithPartnerAccountRequest, T> g) {
        return obj -> g.apply((AssociateAwsAccountWithPartnerAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateAwsAccountWithPartnerAccountRequest> {
        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * 
         * @param sidewalk
         *        The Sidewalk account credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkAccountInfo sidewalk);

        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * This is a convenience that creates an instance of the {@link SidewalkAccountInfo.Builder} avoiding the need
         * to create one manually via {@link SidewalkAccountInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link SidewalkAccountInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #sidewalk(SidewalkAccountInfo)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkAccountInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkAccountInfo)
         */
        default Builder sidewalk(Consumer<SidewalkAccountInfo.Builder> sidewalk) {
            return sidewalk(SidewalkAccountInfo.builder().applyMutation(sidewalk).build());
        }

        /**
         * <p>
         * Each resource must have a unique client request token. If you try to create a new resource with the same
         * token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will
         * automatically generate a unique client request.
         * </p>
         * 
         * @param clientRequestToken
         *        Each resource must have a unique client request token. If you try to create a new resource with the
         *        same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs
         *        will automatically generate a unique client request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private SidewalkAccountInfo sidewalk;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAwsAccountWithPartnerAccountRequest model) {
            super(model);
            sidewalk(model.sidewalk);
            clientRequestToken(model.clientRequestToken);
        }

        public final SidewalkAccountInfo.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkAccountInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final void setSidewalk(SidewalkAccountInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAwsAccountWithPartnerAccountRequest build() {
            return new AssociateAwsAccountWithPartnerAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
