/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterByAssetModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterByAssetModel> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(FilterByAssetModel.getter(FilterByAssetModel::assetModelId)).setter(FilterByAssetModel.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<String> ASSET_MODEL_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelExternalId").getter(FilterByAssetModel.getter(FilterByAssetModel::assetModelExternalId)).setter(FilterByAssetModel.setter(Builder::assetModelExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelExternalId").build()}).build();
    private static final SdkField<Boolean> INCLUDE_OFFSPRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeOffspring").getter(FilterByAssetModel.getter(FilterByAssetModel::includeOffspring)).setter(FilterByAssetModel.setter(Builder::includeOffspring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOffspring").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeAssets").getter(FilterByAssetModel.getter(FilterByAssetModel::includeAssets)).setter(FilterByAssetModel.setter(Builder::includeAssets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAssets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, ASSET_MODEL_EXTERNAL_ID_FIELD, INCLUDE_OFFSPRING_FIELD, INCLUDE_ASSETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterByAssetModel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetModelId;
    private final String assetModelExternalId;
    private final Boolean includeOffspring;
    private final Boolean includeAssets;

    private FilterByAssetModel(BuilderImpl builder) {
        this.assetModelId = builder.assetModelId;
        this.assetModelExternalId = builder.assetModelExternalId;
        this.includeOffspring = builder.includeOffspring;
        this.includeAssets = builder.includeAssets;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String assetModelExternalId() {
        return this.assetModelExternalId;
    }

    public final Boolean includeOffspring() {
        return this.includeOffspring;
    }

    public final Boolean includeAssets() {
        return this.includeAssets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeOffspring());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAssets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterByAssetModel)) {
            return false;
        }
        FilterByAssetModel other = (FilterByAssetModel)obj;
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.assetModelExternalId(), other.assetModelExternalId()) && Objects.equals(this.includeOffspring(), other.includeOffspring()) && Objects.equals(this.includeAssets(), other.includeAssets());
    }

    public final String toString() {
        return ToString.builder((String)"FilterByAssetModel").add("AssetModelId", (Object)this.assetModelId()).add("AssetModelExternalId", (Object)this.assetModelExternalId()).add("IncludeOffspring", (Object)this.includeOffspring()).add("IncludeAssets", (Object)this.includeAssets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetModelExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetModelExternalId()));
            }
            case "includeOffspring": {
                return Optional.ofNullable(clazz.cast(this.includeOffspring()));
            }
            case "includeAssets": {
                return Optional.ofNullable(clazz.cast(this.includeAssets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetModelExternalId", ASSET_MODEL_EXTERNAL_ID_FIELD);
        map.put("includeOffspring", INCLUDE_OFFSPRING_FIELD);
        map.put("includeAssets", INCLUDE_ASSETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterByAssetModel, T> g) {
        return obj -> g.apply((FilterByAssetModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetModelId;
        private String assetModelExternalId;
        private Boolean includeOffspring;
        private Boolean includeAssets;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterByAssetModel model) {
            this.assetModelId(model.assetModelId);
            this.assetModelExternalId(model.assetModelExternalId);
            this.includeOffspring(model.includeOffspring);
            this.includeAssets(model.includeAssets);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelExternalId() {
            return this.assetModelExternalId;
        }

        public final void setAssetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
        }

        @Override
        public final Builder assetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
            return this;
        }

        public final Boolean getIncludeOffspring() {
            return this.includeOffspring;
        }

        public final void setIncludeOffspring(Boolean includeOffspring) {
            this.includeOffspring = includeOffspring;
        }

        @Override
        public final Builder includeOffspring(Boolean includeOffspring) {
            this.includeOffspring = includeOffspring;
            return this;
        }

        public final Boolean getIncludeAssets() {
            return this.includeAssets;
        }

        public final void setIncludeAssets(Boolean includeAssets) {
            this.includeAssets = includeAssets;
        }

        @Override
        public final Builder includeAssets(Boolean includeAssets) {
            this.includeAssets = includeAssets;
            return this;
        }

        public FilterByAssetModel build() {
            return new FilterByAssetModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterByAssetModel> {
        public Builder assetModelId(String var1);

        public Builder assetModelExternalId(String var1);

        public Builder includeOffspring(Boolean var1);

        public Builder includeAssets(Boolean var1);
    }
}

