/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.OrderBy;
import software.amazon.awssdk.services.iottwinmaker.model.OrderByListCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TabularConditions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TabularConditions> {
    private static final SdkField<List<OrderBy>> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orderBy").getter(TabularConditions.getter(TabularConditions::orderBy)).setter(TabularConditions.setter(Builder::orderBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrderBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PropertyFilter>> PROPERTY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyFilters").getter(TabularConditions.getter(TabularConditions::propertyFilters)).setter(TabularConditions.setter(Builder::propertyFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_BY_FIELD, PROPERTY_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TabularConditions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<OrderBy> orderBy;
    private final List<PropertyFilter> propertyFilters;

    private TabularConditions(BuilderImpl builder) {
        this.orderBy = builder.orderBy;
        this.propertyFilters = builder.propertyFilters;
    }

    public final boolean hasOrderBy() {
        return this.orderBy != null && !(this.orderBy instanceof SdkAutoConstructList);
    }

    public final List<OrderBy> orderBy() {
        return this.orderBy;
    }

    public final boolean hasPropertyFilters() {
        return this.propertyFilters != null && !(this.propertyFilters instanceof SdkAutoConstructList);
    }

    public final List<PropertyFilter> propertyFilters() {
        return this.propertyFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderBy() ? this.orderBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyFilters() ? this.propertyFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TabularConditions)) {
            return false;
        }
        TabularConditions other = (TabularConditions)obj;
        return this.hasOrderBy() == other.hasOrderBy() && Objects.equals(this.orderBy(), other.orderBy()) && this.hasPropertyFilters() == other.hasPropertyFilters() && Objects.equals(this.propertyFilters(), other.propertyFilters());
    }

    public final String toString() {
        return ToString.builder((String)"TabularConditions").add("OrderBy", this.hasOrderBy() ? this.orderBy() : null).add("PropertyFilters", this.hasPropertyFilters() ? this.propertyFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "orderBy": {
                return Optional.ofNullable(clazz.cast(this.orderBy()));
            }
            case "propertyFilters": {
                return Optional.ofNullable(clazz.cast(this.propertyFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderBy", ORDER_BY_FIELD);
        map.put("propertyFilters", PROPERTY_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TabularConditions, T> g) {
        return obj -> g.apply((TabularConditions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<OrderBy> orderBy = DefaultSdkAutoConstructList.getInstance();
        private List<PropertyFilter> propertyFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TabularConditions model) {
            this.orderBy(model.orderBy);
            this.propertyFilters(model.propertyFilters);
        }

        public final List<OrderBy.Builder> getOrderBy() {
            List<OrderBy.Builder> result = OrderByListCopier.copyToBuilder(this.orderBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderBy(Collection<OrderBy.BuilderImpl> orderBy) {
            this.orderBy = OrderByListCopier.copyFromBuilder(orderBy);
        }

        @Override
        public final Builder orderBy(Collection<OrderBy> orderBy) {
            this.orderBy = OrderByListCopier.copy(orderBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(OrderBy ... orderBy) {
            this.orderBy(Arrays.asList(orderBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(Consumer<OrderBy.Builder> ... orderBy) {
            this.orderBy(Stream.of(orderBy).map(c -> (OrderBy)((OrderBy.Builder)OrderBy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PropertyFilter.Builder> getPropertyFilters() {
            List<PropertyFilter.Builder> result = PropertyFiltersCopier.copyToBuilder(this.propertyFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyFilters(Collection<PropertyFilter.BuilderImpl> propertyFilters) {
            this.propertyFilters = PropertyFiltersCopier.copyFromBuilder(propertyFilters);
        }

        @Override
        public final Builder propertyFilters(Collection<PropertyFilter> propertyFilters) {
            this.propertyFilters = PropertyFiltersCopier.copy(propertyFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyFilters(PropertyFilter ... propertyFilters) {
            this.propertyFilters(Arrays.asList(propertyFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyFilters(Consumer<PropertyFilter.Builder> ... propertyFilters) {
            this.propertyFilters(Stream.of(propertyFilters).map(c -> (PropertyFilter)((PropertyFilter.Builder)PropertyFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TabularConditions build() {
            return new TabularConditions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TabularConditions> {
        public Builder orderBy(Collection<OrderBy> var1);

        public Builder orderBy(OrderBy ... var1);

        public Builder orderBy(Consumer<OrderBy.Builder> ... var1);

        public Builder propertyFilters(Collection<PropertyFilter> var1);

        public Builder propertyFilters(PropertyFilter ... var1);

        public Builder propertyFilters(Consumer<PropertyFilter.Builder> ... var1);
    }
}

