/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequestsCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentRequest.getter(ComponentRequest::description)).setter(ComponentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(ComponentRequest.getter(ComponentRequest::componentTypeId)).setter(ComponentRequest.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<Map<String, PropertyRequest>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(ComponentRequest.getter(ComponentRequest::properties)).setter(ComponentRequest.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentPropertyGroupRequest>> PROPERTY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyGroups").getter(ComponentRequest.getter(ComponentRequest::propertyGroups)).setter(ComponentRequest.setter(Builder::propertyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentPropertyGroupRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, COMPONENT_TYPE_ID_FIELD, PROPERTIES_FIELD, PROPERTY_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String componentTypeId;
    private final Map<String, PropertyRequest> properties;
    private final Map<String, ComponentPropertyGroupRequest> propertyGroups;

    private ComponentRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.componentTypeId = builder.componentTypeId;
        this.properties = builder.properties;
        this.propertyGroups = builder.propertyGroups;
    }

    public final String description() {
        return this.description;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyRequest> properties() {
        return this.properties;
    }

    public final boolean hasPropertyGroups() {
        return this.propertyGroups != null && !(this.propertyGroups instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentPropertyGroupRequest> propertyGroups() {
        return this.propertyGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyGroups() ? this.propertyGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentRequest)) {
            return false;
        }
        ComponentRequest other = (ComponentRequest)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.componentTypeId(), other.componentTypeId()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(this.propertyGroups(), other.propertyGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentRequest").add("Description", (Object)this.description()).add("ComponentTypeId", (Object)this.componentTypeId()).add("Properties", this.hasProperties() ? this.properties() : null).add("PropertyGroups", this.hasPropertyGroups() ? this.propertyGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "propertyGroups": {
                return Optional.ofNullable(clazz.cast(this.propertyGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("propertyGroups", PROPERTY_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentRequest, T> g) {
        return obj -> g.apply((ComponentRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String componentTypeId;
        private Map<String, PropertyRequest> properties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ComponentPropertyGroupRequest> propertyGroups = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentRequest model) {
            this.description(model.description);
            this.componentTypeId(model.componentTypeId);
            this.properties(model.properties);
            this.propertyGroups(model.propertyGroups);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final Map<String, PropertyRequest.Builder> getProperties() {
            Map<String, PropertyRequest.Builder> result = PropertyRequestsCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, PropertyRequest.BuilderImpl> properties) {
            this.properties = PropertyRequestsCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, PropertyRequest> properties) {
            this.properties = PropertyRequestsCopier.copy(properties);
            return this;
        }

        public final Map<String, ComponentPropertyGroupRequest.Builder> getPropertyGroups() {
            Map<String, ComponentPropertyGroupRequest.Builder> result = ComponentPropertyGroupRequestsCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, ComponentPropertyGroupRequest.BuilderImpl> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupRequestsCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, ComponentPropertyGroupRequest> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupRequestsCopier.copy(propertyGroups);
            return this;
        }

        public ComponentRequest build() {
            return new ComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentRequest> {
        public Builder description(String var1);

        public Builder componentTypeId(String var1);

        public Builder properties(Map<String, PropertyRequest> var1);

        public Builder propertyGroups(Map<String, ComponentPropertyGroupRequest> var1);
    }
}

