/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.PricingBundlesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PricingTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BundleInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BundleInformation> {
    private static final SdkField<List<String>> BUNDLE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bundleNames").getter(BundleInformation.getter(BundleInformation::bundleNames)).setter(BundleInformation.setter(Builder::bundleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRICING_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pricingTier").getter(BundleInformation.getter(BundleInformation::pricingTierAsString)).setter(BundleInformation.setter(Builder::pricingTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingTier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_NAMES_FIELD, PRICING_TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BundleInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> bundleNames;
    private final String pricingTier;

    private BundleInformation(BuilderImpl builder) {
        this.bundleNames = builder.bundleNames;
        this.pricingTier = builder.pricingTier;
    }

    public final boolean hasBundleNames() {
        return this.bundleNames != null && !(this.bundleNames instanceof SdkAutoConstructList);
    }

    public final List<String> bundleNames() {
        return this.bundleNames;
    }

    public final PricingTier pricingTier() {
        return PricingTier.fromValue(this.pricingTier);
    }

    public final String pricingTierAsString() {
        return this.pricingTier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundleNames() ? this.bundleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingTierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInformation)) {
            return false;
        }
        BundleInformation other = (BundleInformation)obj;
        return this.hasBundleNames() == other.hasBundleNames() && Objects.equals(this.bundleNames(), other.bundleNames()) && Objects.equals(this.pricingTierAsString(), other.pricingTierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BundleInformation").add("BundleNames", this.hasBundleNames() ? this.bundleNames() : null).add("PricingTier", (Object)this.pricingTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundleNames": {
                return Optional.ofNullable(clazz.cast(this.bundleNames()));
            }
            case "pricingTier": {
                return Optional.ofNullable(clazz.cast(this.pricingTierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bundleNames", BUNDLE_NAMES_FIELD);
        map.put("pricingTier", PRICING_TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BundleInformation, T> g) {
        return obj -> g.apply((BundleInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> bundleNames = DefaultSdkAutoConstructList.getInstance();
        private String pricingTier;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleInformation model) {
            this.bundleNames(model.bundleNames);
            this.pricingTier(model.pricingTier);
        }

        public final Collection<String> getBundleNames() {
            if (this.bundleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bundleNames;
        }

        public final void setBundleNames(Collection<String> bundleNames) {
            this.bundleNames = PricingBundlesCopier.copy(bundleNames);
        }

        @Override
        public final Builder bundleNames(Collection<String> bundleNames) {
            this.bundleNames = PricingBundlesCopier.copy(bundleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleNames(String ... bundleNames) {
            this.bundleNames(Arrays.asList(bundleNames));
            return this;
        }

        public final String getPricingTier() {
            return this.pricingTier;
        }

        public final void setPricingTier(String pricingTier) {
            this.pricingTier = pricingTier;
        }

        @Override
        public final Builder pricingTier(String pricingTier) {
            this.pricingTier = pricingTier;
            return this;
        }

        @Override
        public final Builder pricingTier(PricingTier pricingTier) {
            this.pricingTier(pricingTier == null ? null : pricingTier.toString());
            return this;
        }

        public BundleInformation build() {
            return new BundleInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BundleInformation> {
        public Builder bundleNames(Collection<String> var1);

        public Builder bundleNames(String ... var1);

        public Builder pricingTier(String var1);

        public Builder pricingTier(PricingTier var1);
    }
}

