/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PricingBundlesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PricingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePricingPlanRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, UpdatePricingPlanRequest> {
    private static final SdkField<String> PRICING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pricingMode").getter(UpdatePricingPlanRequest.getter(UpdatePricingPlanRequest::pricingModeAsString)).setter(UpdatePricingPlanRequest.setter(Builder::pricingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingMode").build()}).build();
    private static final SdkField<List<String>> BUNDLE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bundleNames").getter(UpdatePricingPlanRequest.getter(UpdatePricingPlanRequest::bundleNames)).setter(UpdatePricingPlanRequest.setter(Builder::bundleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_MODE_FIELD, BUNDLE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePricingPlanRequest.memberNameToFieldInitializer();
    private final String pricingMode;
    private final List<String> bundleNames;

    private UpdatePricingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.pricingMode = builder.pricingMode;
        this.bundleNames = builder.bundleNames;
    }

    public final PricingMode pricingMode() {
        return PricingMode.fromValue(this.pricingMode);
    }

    public final String pricingModeAsString() {
        return this.pricingMode;
    }

    public final boolean hasBundleNames() {
        return this.bundleNames != null && !(this.bundleNames instanceof SdkAutoConstructList);
    }

    public final List<String> bundleNames() {
        return this.bundleNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundleNames() ? this.bundleNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePricingPlanRequest)) {
            return false;
        }
        UpdatePricingPlanRequest other = (UpdatePricingPlanRequest)((Object)obj);
        return Objects.equals(this.pricingModeAsString(), other.pricingModeAsString()) && this.hasBundleNames() == other.hasBundleNames() && Objects.equals(this.bundleNames(), other.bundleNames());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePricingPlanRequest").add("PricingMode", (Object)this.pricingModeAsString()).add("BundleNames", this.hasBundleNames() ? this.bundleNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pricingMode": {
                return Optional.ofNullable(clazz.cast(this.pricingModeAsString()));
            }
            case "bundleNames": {
                return Optional.ofNullable(clazz.cast(this.bundleNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pricingMode", PRICING_MODE_FIELD);
        map.put("bundleNames", BUNDLE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePricingPlanRequest, T> g) {
        return obj -> g.apply((UpdatePricingPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String pricingMode;
        private List<String> bundleNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePricingPlanRequest model) {
            super(model);
            this.pricingMode(model.pricingMode);
            this.bundleNames(model.bundleNames);
        }

        public final String getPricingMode() {
            return this.pricingMode;
        }

        public final void setPricingMode(String pricingMode) {
            this.pricingMode = pricingMode;
        }

        @Override
        public final Builder pricingMode(String pricingMode) {
            this.pricingMode = pricingMode;
            return this;
        }

        @Override
        public final Builder pricingMode(PricingMode pricingMode) {
            this.pricingMode(pricingMode == null ? null : pricingMode.toString());
            return this;
        }

        public final Collection<String> getBundleNames() {
            if (this.bundleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bundleNames;
        }

        public final void setBundleNames(Collection<String> bundleNames) {
            this.bundleNames = PricingBundlesCopier.copy(bundleNames);
        }

        @Override
        public final Builder bundleNames(Collection<String> bundleNames) {
            this.bundleNames = PricingBundlesCopier.copy(bundleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleNames(String ... bundleNames) {
            this.bundleNames(Arrays.asList(bundleNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePricingPlanRequest build() {
            return new UpdatePricingPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePricingPlanRequest> {
        public Builder pricingMode(String var1);

        public Builder pricingMode(PricingMode var1);

        public Builder bundleNames(Collection<String> var1);

        public Builder bundleNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

