/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterByAsset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterByAsset> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(FilterByAsset.getter(FilterByAsset::assetId)).setter(FilterByAsset.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetExternalId").getter(FilterByAsset.getter(FilterByAsset::assetExternalId)).setter(FilterByAsset.setter(Builder::assetExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetExternalId").build()}).build();
    private static final SdkField<Boolean> INCLUDE_OFFSPRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeOffspring").getter(FilterByAsset.getter(FilterByAsset::includeOffspring)).setter(FilterByAsset.setter(Builder::includeOffspring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOffspring").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ASSET_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeAssetModel").getter(FilterByAsset.getter(FilterByAsset::includeAssetModel)).setter(FilterByAsset.setter(Builder::includeAssetModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAssetModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_EXTERNAL_ID_FIELD, INCLUDE_OFFSPRING_FIELD, INCLUDE_ASSET_MODEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterByAsset.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String assetExternalId;
    private final Boolean includeOffspring;
    private final Boolean includeAssetModel;

    private FilterByAsset(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.assetExternalId = builder.assetExternalId;
        this.includeOffspring = builder.includeOffspring;
        this.includeAssetModel = builder.includeAssetModel;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String assetExternalId() {
        return this.assetExternalId;
    }

    public final Boolean includeOffspring() {
        return this.includeOffspring;
    }

    public final Boolean includeAssetModel() {
        return this.includeAssetModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeOffspring());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAssetModel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterByAsset)) {
            return false;
        }
        FilterByAsset other = (FilterByAsset)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetExternalId(), other.assetExternalId()) && Objects.equals(this.includeOffspring(), other.includeOffspring()) && Objects.equals(this.includeAssetModel(), other.includeAssetModel());
    }

    public final String toString() {
        return ToString.builder((String)"FilterByAsset").add("AssetId", (Object)this.assetId()).add("AssetExternalId", (Object)this.assetExternalId()).add("IncludeOffspring", (Object)this.includeOffspring()).add("IncludeAssetModel", (Object)this.includeAssetModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetExternalId()));
            }
            case "includeOffspring": {
                return Optional.ofNullable(clazz.cast(this.includeOffspring()));
            }
            case "includeAssetModel": {
                return Optional.ofNullable(clazz.cast(this.includeAssetModel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetExternalId", ASSET_EXTERNAL_ID_FIELD);
        map.put("includeOffspring", INCLUDE_OFFSPRING_FIELD);
        map.put("includeAssetModel", INCLUDE_ASSET_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterByAsset, T> g) {
        return obj -> g.apply((FilterByAsset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String assetExternalId;
        private Boolean includeOffspring;
        private Boolean includeAssetModel;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterByAsset model) {
            this.assetId(model.assetId);
            this.assetExternalId(model.assetExternalId);
            this.includeOffspring(model.includeOffspring);
            this.includeAssetModel(model.includeAssetModel);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetExternalId() {
            return this.assetExternalId;
        }

        public final void setAssetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
        }

        @Override
        public final Builder assetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
            return this;
        }

        public final Boolean getIncludeOffspring() {
            return this.includeOffspring;
        }

        public final void setIncludeOffspring(Boolean includeOffspring) {
            this.includeOffspring = includeOffspring;
        }

        @Override
        public final Builder includeOffspring(Boolean includeOffspring) {
            this.includeOffspring = includeOffspring;
            return this;
        }

        public final Boolean getIncludeAssetModel() {
            return this.includeAssetModel;
        }

        public final void setIncludeAssetModel(Boolean includeAssetModel) {
            this.includeAssetModel = includeAssetModel;
        }

        @Override
        public final Builder includeAssetModel(Boolean includeAssetModel) {
            this.includeAssetModel = includeAssetModel;
            return this;
        }

        public FilterByAsset build() {
            return new FilterByAsset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterByAsset> {
        public Builder assetId(String var1);

        public Builder assetExternalId(String var1);

        public Builder includeOffspring(Boolean var1);

        public Builder includeAssetModel(Boolean var1);
    }
}

