/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertySummariesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PropertySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPropertiesResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, ListPropertiesResponse> {
    private static final SdkField<List<PropertySummary>> PROPERTY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertySummaries").getter(ListPropertiesResponse.getter(ListPropertiesResponse::propertySummaries)).setter(ListPropertiesResponse.setter(Builder::propertySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPropertiesResponse.getter(ListPropertiesResponse::nextToken)).setter(ListPropertiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPropertiesResponse.memberNameToFieldInitializer();
    private final List<PropertySummary> propertySummaries;
    private final String nextToken;

    private ListPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.propertySummaries = builder.propertySummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPropertySummaries() {
        return this.propertySummaries != null && !(this.propertySummaries instanceof SdkAutoConstructList);
    }

    public final List<PropertySummary> propertySummaries() {
        return this.propertySummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertySummaries() ? this.propertySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPropertiesResponse)) {
            return false;
        }
        ListPropertiesResponse other = (ListPropertiesResponse)((Object)obj);
        return this.hasPropertySummaries() == other.hasPropertySummaries() && Objects.equals(this.propertySummaries(), other.propertySummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPropertiesResponse").add("PropertySummaries", this.hasPropertySummaries() ? this.propertySummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "propertySummaries": {
                return Optional.ofNullable(clazz.cast(this.propertySummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertySummaries", PROPERTY_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPropertiesResponse, T> g) {
        return obj -> g.apply((ListPropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private List<PropertySummary> propertySummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPropertiesResponse model) {
            super(model);
            this.propertySummaries(model.propertySummaries);
            this.nextToken(model.nextToken);
        }

        public final List<PropertySummary.Builder> getPropertySummaries() {
            List<PropertySummary.Builder> result = PropertySummariesCopier.copyToBuilder(this.propertySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertySummaries(Collection<PropertySummary.BuilderImpl> propertySummaries) {
            this.propertySummaries = PropertySummariesCopier.copyFromBuilder(propertySummaries);
        }

        @Override
        public final Builder propertySummaries(Collection<PropertySummary> propertySummaries) {
            this.propertySummaries = PropertySummariesCopier.copy(propertySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertySummaries(PropertySummary ... propertySummaries) {
            this.propertySummaries(Arrays.asList(propertySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertySummaries(Consumer<PropertySummary.Builder> ... propertySummaries) {
            this.propertySummaries(Stream.of(propertySummaries).map(c -> (PropertySummary)((PropertySummary.Builder)PropertySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPropertiesResponse build() {
            return new ListPropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPropertiesResponse> {
        public Builder propertySummaries(Collection<PropertySummary> var1);

        public Builder propertySummaries(PropertySummary ... var1);

        public Builder propertySummaries(Consumer<PropertySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

