/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ConfigurationCopier;
import software.amazon.awssdk.services.iottwinmaker.model.DataType;
import software.amazon.awssdk.services.iottwinmaker.model.DataValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyDefinitionRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyDefinitionRequest> {
    private static final SdkField<DataType> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataType").getter(PropertyDefinitionRequest.getter(PropertyDefinitionRequest::dataType)).setter(PropertyDefinitionRequest.setter(Builder::dataType)).constructor(DataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Boolean> IS_REQUIRED_IN_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRequiredInEntity").getter(PropertyDefinitionRequest.getter(PropertyDefinitionRequest::isRequiredInEntity)).setter(PropertyDefinitionRequest.setter(Builder::isRequiredInEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequiredInEntity").build()}).build();
    private static final SdkField<Boolean> IS_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isExternalId").getter(PropertyDefinitionRequest.getter(PropertyDefinitionRequest::isExternalId)).setter(PropertyDefinitionRequest.setter(Builder::isExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isExternalId").build()}).build();
    private static final SdkField<Boolean> IS_STORED_EXTERNALLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isStoredExternally").getter(PropertyDefinitionRequest.getter(PropertyDefinitionRequest::isStoredExternally)).setter(PropertyDefinitionRequest.setter(Builder::isStoredExternally)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isStoredExternally").build()}).build();
    private static final SdkField<Boolean> IS_TIME_SERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isTimeSeries").getter(PropertyDefinitionRequest.getter(PropertyDefinitionRequest::isTimeSeries)).setter(PropertyDefinitionRequest.setter(Builder::isTimeSeries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTimeSeries").build()}).build();
    private static final SdkField<DataValue> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultValue").getter(PropertyDefinitionRequest.getter(PropertyDefinitionRequest::defaultValue)).setter(PropertyDefinitionRequest.setter(Builder::defaultValue)).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(PropertyDefinitionRequest.getter(PropertyDefinitionRequest::configuration)).setter(PropertyDefinitionRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(PropertyDefinitionRequest.getter(PropertyDefinitionRequest::displayName)).setter(PropertyDefinitionRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TYPE_FIELD, IS_REQUIRED_IN_ENTITY_FIELD, IS_EXTERNAL_ID_FIELD, IS_STORED_EXTERNALLY_FIELD, IS_TIME_SERIES_FIELD, DEFAULT_VALUE_FIELD, CONFIGURATION_FIELD, DISPLAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PropertyDefinitionRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataType dataType;
    private final Boolean isRequiredInEntity;
    private final Boolean isExternalId;
    private final Boolean isStoredExternally;
    private final Boolean isTimeSeries;
    private final DataValue defaultValue;
    private final Map<String, String> configuration;
    private final String displayName;

    private PropertyDefinitionRequest(BuilderImpl builder) {
        this.dataType = builder.dataType;
        this.isRequiredInEntity = builder.isRequiredInEntity;
        this.isExternalId = builder.isExternalId;
        this.isStoredExternally = builder.isStoredExternally;
        this.isTimeSeries = builder.isTimeSeries;
        this.defaultValue = builder.defaultValue;
        this.configuration = builder.configuration;
        this.displayName = builder.displayName;
    }

    public final DataType dataType() {
        return this.dataType;
    }

    public final Boolean isRequiredInEntity() {
        return this.isRequiredInEntity;
    }

    public final Boolean isExternalId() {
        return this.isExternalId;
    }

    public final Boolean isStoredExternally() {
        return this.isStoredExternally;
    }

    public final Boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public final DataValue defaultValue() {
        return this.defaultValue;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> configuration() {
        return this.configuration;
    }

    public final String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequiredInEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.isExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isStoredExternally());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTimeSeries());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyDefinitionRequest)) {
            return false;
        }
        PropertyDefinitionRequest other = (PropertyDefinitionRequest)obj;
        return Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.isRequiredInEntity(), other.isRequiredInEntity()) && Objects.equals(this.isExternalId(), other.isExternalId()) && Objects.equals(this.isStoredExternally(), other.isStoredExternally()) && Objects.equals(this.isTimeSeries(), other.isTimeSeries()) && Objects.equals(this.defaultValue(), other.defaultValue()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyDefinitionRequest").add("DataType", (Object)this.dataType()).add("IsRequiredInEntity", (Object)this.isRequiredInEntity()).add("IsExternalId", (Object)this.isExternalId()).add("IsStoredExternally", (Object)this.isStoredExternally()).add("IsTimeSeries", (Object)this.isTimeSeries()).add("DefaultValue", (Object)this.defaultValue()).add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("DisplayName", (Object)this.displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "isRequiredInEntity": {
                return Optional.ofNullable(clazz.cast(this.isRequiredInEntity()));
            }
            case "isExternalId": {
                return Optional.ofNullable(clazz.cast(this.isExternalId()));
            }
            case "isStoredExternally": {
                return Optional.ofNullable(clazz.cast(this.isStoredExternally()));
            }
            case "isTimeSeries": {
                return Optional.ofNullable(clazz.cast(this.isTimeSeries()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("isRequiredInEntity", IS_REQUIRED_IN_ENTITY_FIELD);
        map.put("isExternalId", IS_EXTERNAL_ID_FIELD);
        map.put("isStoredExternally", IS_STORED_EXTERNALLY_FIELD);
        map.put("isTimeSeries", IS_TIME_SERIES_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyDefinitionRequest, T> g) {
        return obj -> g.apply((PropertyDefinitionRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataType dataType;
        private Boolean isRequiredInEntity;
        private Boolean isExternalId;
        private Boolean isStoredExternally;
        private Boolean isTimeSeries;
        private DataValue defaultValue;
        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyDefinitionRequest model) {
            this.dataType(model.dataType);
            this.isRequiredInEntity(model.isRequiredInEntity);
            this.isExternalId(model.isExternalId);
            this.isStoredExternally(model.isStoredExternally);
            this.isTimeSeries(model.isTimeSeries);
            this.defaultValue(model.defaultValue);
            this.configuration(model.configuration);
            this.displayName(model.displayName);
        }

        public final DataType.Builder getDataType() {
            return this.dataType != null ? this.dataType.toBuilder() : null;
        }

        public final void setDataType(DataType.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public final Boolean getIsRequiredInEntity() {
            return this.isRequiredInEntity;
        }

        public final void setIsRequiredInEntity(Boolean isRequiredInEntity) {
            this.isRequiredInEntity = isRequiredInEntity;
        }

        @Override
        public final Builder isRequiredInEntity(Boolean isRequiredInEntity) {
            this.isRequiredInEntity = isRequiredInEntity;
            return this;
        }

        public final Boolean getIsExternalId() {
            return this.isExternalId;
        }

        public final void setIsExternalId(Boolean isExternalId) {
            this.isExternalId = isExternalId;
        }

        @Override
        public final Builder isExternalId(Boolean isExternalId) {
            this.isExternalId = isExternalId;
            return this;
        }

        public final Boolean getIsStoredExternally() {
            return this.isStoredExternally;
        }

        public final void setIsStoredExternally(Boolean isStoredExternally) {
            this.isStoredExternally = isStoredExternally;
        }

        @Override
        public final Builder isStoredExternally(Boolean isStoredExternally) {
            this.isStoredExternally = isStoredExternally;
            return this;
        }

        public final Boolean getIsTimeSeries() {
            return this.isTimeSeries;
        }

        public final void setIsTimeSeries(Boolean isTimeSeries) {
            this.isTimeSeries = isTimeSeries;
        }

        @Override
        public final Builder isTimeSeries(Boolean isTimeSeries) {
            this.isTimeSeries = isTimeSeries;
            return this;
        }

        public final DataValue.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(DataValue.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        @Override
        public final Builder defaultValue(DataValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Map<String, String> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configuration;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public PropertyDefinitionRequest build() {
            return new PropertyDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyDefinitionRequest> {
        public Builder dataType(DataType var1);

        default public Builder dataType(Consumer<DataType.Builder> dataType) {
            return this.dataType((DataType)((DataType.Builder)DataType.builder().applyMutation(dataType)).build());
        }

        public Builder isRequiredInEntity(Boolean var1);

        public Builder isExternalId(Boolean var1);

        public Builder isStoredExternally(Boolean var1);

        public Builder isTimeSeries(Boolean var1);

        public Builder defaultValue(DataValue var1);

        default public Builder defaultValue(Consumer<DataValue.Builder> defaultValue) {
            return this.defaultValue((DataValue)((DataValue.Builder)DataValue.builder().applyMutation(defaultValue)).build());
        }

        public Builder configuration(Map<String, String> var1);

        public Builder displayName(String var1);
    }
}

