/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PricingMode {
    BASIC("BASIC"),
    STANDARD("STANDARD"),
    TIERED_BUNDLE("TIERED_BUNDLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PricingMode> VALUE_MAP;
    private final String value;

    private PricingMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PricingMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PricingMode> knownValues() {
        EnumSet<PricingMode> knownValues = EnumSet.allOf(PricingMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PricingMode.class, PricingMode::toString);
    }
}

