/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequestsCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompositeComponentRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompositeComponentRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CompositeComponentRequest.getter(CompositeComponentRequest::description)).setter(CompositeComponentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, PropertyRequest>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(CompositeComponentRequest.getter(CompositeComponentRequest::properties)).setter(CompositeComponentRequest.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentPropertyGroupRequest>> PROPERTY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyGroups").getter(CompositeComponentRequest.getter(CompositeComponentRequest::propertyGroups)).setter(CompositeComponentRequest.setter(Builder::propertyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentPropertyGroupRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, PROPERTIES_FIELD, PROPERTY_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("description", DESCRIPTION_FIELD);
            this.put("properties", PROPERTIES_FIELD);
            this.put("propertyGroups", PROPERTY_GROUPS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Map<String, PropertyRequest> properties;
    private final Map<String, ComponentPropertyGroupRequest> propertyGroups;

    private CompositeComponentRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.properties = builder.properties;
        this.propertyGroups = builder.propertyGroups;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyRequest> properties() {
        return this.properties;
    }

    public final boolean hasPropertyGroups() {
        return this.propertyGroups != null && !(this.propertyGroups instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentPropertyGroupRequest> propertyGroups() {
        return this.propertyGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyGroups() ? this.propertyGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeComponentRequest)) {
            return false;
        }
        CompositeComponentRequest other = (CompositeComponentRequest)obj;
        return Objects.equals(this.description(), other.description()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(this.propertyGroups(), other.propertyGroups());
    }

    public final String toString() {
        return ToString.builder((String)"CompositeComponentRequest").add("Description", (Object)this.description()).add("Properties", this.hasProperties() ? this.properties() : null).add("PropertyGroups", this.hasPropertyGroups() ? this.propertyGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "propertyGroups": {
                return Optional.ofNullable(clazz.cast(this.propertyGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CompositeComponentRequest, T> g) {
        return obj -> g.apply((CompositeComponentRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Map<String, PropertyRequest> properties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ComponentPropertyGroupRequest> propertyGroups = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeComponentRequest model) {
            this.description(model.description);
            this.properties(model.properties);
            this.propertyGroups(model.propertyGroups);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyRequest.Builder> getProperties() {
            Map<String, PropertyRequest.Builder> result = PropertyRequestsCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, PropertyRequest.BuilderImpl> properties) {
            this.properties = PropertyRequestsCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, PropertyRequest> properties) {
            this.properties = PropertyRequestsCopier.copy(properties);
            return this;
        }

        public final Map<String, ComponentPropertyGroupRequest.Builder> getPropertyGroups() {
            Map<String, ComponentPropertyGroupRequest.Builder> result = ComponentPropertyGroupRequestsCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, ComponentPropertyGroupRequest.BuilderImpl> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupRequestsCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, ComponentPropertyGroupRequest> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupRequestsCopier.copy(propertyGroups);
            return this;
        }

        public CompositeComponentRequest build() {
            return new CompositeComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompositeComponentRequest> {
        public Builder description(String var1);

        public Builder properties(Map<String, PropertyRequest> var1);

        public Builder propertyGroups(Map<String, ComponentPropertyGroupRequest> var1);
    }
}

