/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ConfigurationCopier;
import software.amazon.awssdk.services.iottwinmaker.model.DataType;
import software.amazon.awssdk.services.iottwinmaker.model.DataValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyDefinitionResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyDefinitionResponse> {
    private static final SdkField<DataType> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataType").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::dataType)).setter(PropertyDefinitionResponse.setter(Builder::dataType)).constructor(DataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Boolean> IS_TIME_SERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isTimeSeries").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isTimeSeries)).setter(PropertyDefinitionResponse.setter(Builder::isTimeSeries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTimeSeries").build()}).build();
    private static final SdkField<Boolean> IS_REQUIRED_IN_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRequiredInEntity").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isRequiredInEntity)).setter(PropertyDefinitionResponse.setter(Builder::isRequiredInEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequiredInEntity").build()}).build();
    private static final SdkField<Boolean> IS_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isExternalId").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isExternalId)).setter(PropertyDefinitionResponse.setter(Builder::isExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isExternalId").build()}).build();
    private static final SdkField<Boolean> IS_STORED_EXTERNALLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isStoredExternally").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isStoredExternally)).setter(PropertyDefinitionResponse.setter(Builder::isStoredExternally)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isStoredExternally").build()}).build();
    private static final SdkField<Boolean> IS_IMPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isImported").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isImported)).setter(PropertyDefinitionResponse.setter(Builder::isImported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isImported").build()}).build();
    private static final SdkField<Boolean> IS_FINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isFinal").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isFinal)).setter(PropertyDefinitionResponse.setter(Builder::isFinal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isFinal").build()}).build();
    private static final SdkField<Boolean> IS_INHERITED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isInherited").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::isInherited)).setter(PropertyDefinitionResponse.setter(Builder::isInherited)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInherited").build()}).build();
    private static final SdkField<DataValue> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultValue").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::defaultValue)).setter(PropertyDefinitionResponse.setter(Builder::defaultValue)).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::configuration)).setter(PropertyDefinitionResponse.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(PropertyDefinitionResponse.getter(PropertyDefinitionResponse::displayName)).setter(PropertyDefinitionResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TYPE_FIELD, IS_TIME_SERIES_FIELD, IS_REQUIRED_IN_ENTITY_FIELD, IS_EXTERNAL_ID_FIELD, IS_STORED_EXTERNALLY_FIELD, IS_IMPORTED_FIELD, IS_FINAL_FIELD, IS_INHERITED_FIELD, DEFAULT_VALUE_FIELD, CONFIGURATION_FIELD, DISPLAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dataType", DATA_TYPE_FIELD);
            this.put("isTimeSeries", IS_TIME_SERIES_FIELD);
            this.put("isRequiredInEntity", IS_REQUIRED_IN_ENTITY_FIELD);
            this.put("isExternalId", IS_EXTERNAL_ID_FIELD);
            this.put("isStoredExternally", IS_STORED_EXTERNALLY_FIELD);
            this.put("isImported", IS_IMPORTED_FIELD);
            this.put("isFinal", IS_FINAL_FIELD);
            this.put("isInherited", IS_INHERITED_FIELD);
            this.put("defaultValue", DEFAULT_VALUE_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DataType dataType;
    private final Boolean isTimeSeries;
    private final Boolean isRequiredInEntity;
    private final Boolean isExternalId;
    private final Boolean isStoredExternally;
    private final Boolean isImported;
    private final Boolean isFinal;
    private final Boolean isInherited;
    private final DataValue defaultValue;
    private final Map<String, String> configuration;
    private final String displayName;

    private PropertyDefinitionResponse(BuilderImpl builder) {
        this.dataType = builder.dataType;
        this.isTimeSeries = builder.isTimeSeries;
        this.isRequiredInEntity = builder.isRequiredInEntity;
        this.isExternalId = builder.isExternalId;
        this.isStoredExternally = builder.isStoredExternally;
        this.isImported = builder.isImported;
        this.isFinal = builder.isFinal;
        this.isInherited = builder.isInherited;
        this.defaultValue = builder.defaultValue;
        this.configuration = builder.configuration;
        this.displayName = builder.displayName;
    }

    public final DataType dataType() {
        return this.dataType;
    }

    public final Boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public final Boolean isRequiredInEntity() {
        return this.isRequiredInEntity;
    }

    public final Boolean isExternalId() {
        return this.isExternalId;
    }

    public final Boolean isStoredExternally() {
        return this.isStoredExternally;
    }

    public final Boolean isImported() {
        return this.isImported;
    }

    public final Boolean isFinal() {
        return this.isFinal;
    }

    public final Boolean isInherited() {
        return this.isInherited;
    }

    public final DataValue defaultValue() {
        return this.defaultValue;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> configuration() {
        return this.configuration;
    }

    public final String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTimeSeries());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequiredInEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.isExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isStoredExternally());
        hashCode = 31 * hashCode + Objects.hashCode(this.isImported());
        hashCode = 31 * hashCode + Objects.hashCode(this.isFinal());
        hashCode = 31 * hashCode + Objects.hashCode(this.isInherited());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyDefinitionResponse)) {
            return false;
        }
        PropertyDefinitionResponse other = (PropertyDefinitionResponse)obj;
        return Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.isTimeSeries(), other.isTimeSeries()) && Objects.equals(this.isRequiredInEntity(), other.isRequiredInEntity()) && Objects.equals(this.isExternalId(), other.isExternalId()) && Objects.equals(this.isStoredExternally(), other.isStoredExternally()) && Objects.equals(this.isImported(), other.isImported()) && Objects.equals(this.isFinal(), other.isFinal()) && Objects.equals(this.isInherited(), other.isInherited()) && Objects.equals(this.defaultValue(), other.defaultValue()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyDefinitionResponse").add("DataType", (Object)this.dataType()).add("IsTimeSeries", (Object)this.isTimeSeries()).add("IsRequiredInEntity", (Object)this.isRequiredInEntity()).add("IsExternalId", (Object)this.isExternalId()).add("IsStoredExternally", (Object)this.isStoredExternally()).add("IsImported", (Object)this.isImported()).add("IsFinal", (Object)this.isFinal()).add("IsInherited", (Object)this.isInherited()).add("DefaultValue", (Object)this.defaultValue()).add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("DisplayName", (Object)this.displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "isTimeSeries": {
                return Optional.ofNullable(clazz.cast(this.isTimeSeries()));
            }
            case "isRequiredInEntity": {
                return Optional.ofNullable(clazz.cast(this.isRequiredInEntity()));
            }
            case "isExternalId": {
                return Optional.ofNullable(clazz.cast(this.isExternalId()));
            }
            case "isStoredExternally": {
                return Optional.ofNullable(clazz.cast(this.isStoredExternally()));
            }
            case "isImported": {
                return Optional.ofNullable(clazz.cast(this.isImported()));
            }
            case "isFinal": {
                return Optional.ofNullable(clazz.cast(this.isFinal()));
            }
            case "isInherited": {
                return Optional.ofNullable(clazz.cast(this.isInherited()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PropertyDefinitionResponse, T> g) {
        return obj -> g.apply((PropertyDefinitionResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataType dataType;
        private Boolean isTimeSeries;
        private Boolean isRequiredInEntity;
        private Boolean isExternalId;
        private Boolean isStoredExternally;
        private Boolean isImported;
        private Boolean isFinal;
        private Boolean isInherited;
        private DataValue defaultValue;
        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyDefinitionResponse model) {
            this.dataType(model.dataType);
            this.isTimeSeries(model.isTimeSeries);
            this.isRequiredInEntity(model.isRequiredInEntity);
            this.isExternalId(model.isExternalId);
            this.isStoredExternally(model.isStoredExternally);
            this.isImported(model.isImported);
            this.isFinal(model.isFinal);
            this.isInherited(model.isInherited);
            this.defaultValue(model.defaultValue);
            this.configuration(model.configuration);
            this.displayName(model.displayName);
        }

        public final DataType.Builder getDataType() {
            return this.dataType != null ? this.dataType.toBuilder() : null;
        }

        public final void setDataType(DataType.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public final Boolean getIsTimeSeries() {
            return this.isTimeSeries;
        }

        public final void setIsTimeSeries(Boolean isTimeSeries) {
            this.isTimeSeries = isTimeSeries;
        }

        @Override
        public final Builder isTimeSeries(Boolean isTimeSeries) {
            this.isTimeSeries = isTimeSeries;
            return this;
        }

        public final Boolean getIsRequiredInEntity() {
            return this.isRequiredInEntity;
        }

        public final void setIsRequiredInEntity(Boolean isRequiredInEntity) {
            this.isRequiredInEntity = isRequiredInEntity;
        }

        @Override
        public final Builder isRequiredInEntity(Boolean isRequiredInEntity) {
            this.isRequiredInEntity = isRequiredInEntity;
            return this;
        }

        public final Boolean getIsExternalId() {
            return this.isExternalId;
        }

        public final void setIsExternalId(Boolean isExternalId) {
            this.isExternalId = isExternalId;
        }

        @Override
        public final Builder isExternalId(Boolean isExternalId) {
            this.isExternalId = isExternalId;
            return this;
        }

        public final Boolean getIsStoredExternally() {
            return this.isStoredExternally;
        }

        public final void setIsStoredExternally(Boolean isStoredExternally) {
            this.isStoredExternally = isStoredExternally;
        }

        @Override
        public final Builder isStoredExternally(Boolean isStoredExternally) {
            this.isStoredExternally = isStoredExternally;
            return this;
        }

        public final Boolean getIsImported() {
            return this.isImported;
        }

        public final void setIsImported(Boolean isImported) {
            this.isImported = isImported;
        }

        @Override
        public final Builder isImported(Boolean isImported) {
            this.isImported = isImported;
            return this;
        }

        public final Boolean getIsFinal() {
            return this.isFinal;
        }

        public final void setIsFinal(Boolean isFinal) {
            this.isFinal = isFinal;
        }

        @Override
        public final Builder isFinal(Boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public final Boolean getIsInherited() {
            return this.isInherited;
        }

        public final void setIsInherited(Boolean isInherited) {
            this.isInherited = isInherited;
        }

        @Override
        public final Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        public final DataValue.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(DataValue.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        @Override
        public final Builder defaultValue(DataValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Map<String, String> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configuration;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public PropertyDefinitionResponse build() {
            return new PropertyDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyDefinitionResponse> {
        public Builder dataType(DataType var1);

        default public Builder dataType(Consumer<DataType.Builder> dataType) {
            return this.dataType((DataType)((DataType.Builder)DataType.builder().applyMutation(dataType)).build());
        }

        public Builder isTimeSeries(Boolean var1);

        public Builder isRequiredInEntity(Boolean var1);

        public Builder isExternalId(Boolean var1);

        public Builder isStoredExternally(Boolean var1);

        public Builder isImported(Boolean var1);

        public Builder isFinal(Boolean var1);

        public Builder isInherited(Boolean var1);

        public Builder defaultValue(DataValue var1);

        default public Builder defaultValue(Consumer<DataValue.Builder> defaultValue) {
            return this.defaultValue((DataValue)((DataValue.Builder)DataValue.builder().applyMutation(defaultValue)).build());
        }

        public Builder configuration(Map<String, String> var1);

        public Builder displayName(String var1);
    }
}

