/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SceneErrorCode {
    MATTERPORT_ERROR("MATTERPORT_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SceneErrorCode> VALUE_MAP;
    private final String value;

    private SceneErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SceneErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SceneErrorCode> knownValues() {
        EnumSet<SceneErrorCode> knownValues = EnumSet.allOf(SceneErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SceneErrorCode.class, SceneErrorCode::toString);
    }
}

