/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.GroupType;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyGroupResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyGroupResponse> {
    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupType").getter(PropertyGroupResponse.getter(PropertyGroupResponse::groupTypeAsString)).setter(PropertyGroupResponse.setter(Builder::groupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupType").build()}).build();
    private static final SdkField<List<String>> PROPERTY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyNames").getter(PropertyGroupResponse.getter(PropertyGroupResponse::propertyNames)).setter(PropertyGroupResponse.setter(Builder::propertyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_INHERITED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isInherited").getter(PropertyGroupResponse.getter(PropertyGroupResponse::isInherited)).setter(PropertyGroupResponse.setter(Builder::isInherited)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInherited").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_TYPE_FIELD, PROPERTY_NAMES_FIELD, IS_INHERITED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupType;
    private final List<String> propertyNames;
    private final Boolean isInherited;

    private PropertyGroupResponse(BuilderImpl builder) {
        this.groupType = builder.groupType;
        this.propertyNames = builder.propertyNames;
        this.isInherited = builder.isInherited;
    }

    public final GroupType groupType() {
        return GroupType.fromValue(this.groupType);
    }

    public final String groupTypeAsString() {
        return this.groupType;
    }

    public final boolean hasPropertyNames() {
        return this.propertyNames != null && !(this.propertyNames instanceof SdkAutoConstructList);
    }

    public final List<String> propertyNames() {
        return this.propertyNames;
    }

    public final Boolean isInherited() {
        return this.isInherited;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyNames() ? this.propertyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isInherited());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyGroupResponse)) {
            return false;
        }
        PropertyGroupResponse other = (PropertyGroupResponse)obj;
        return Objects.equals(this.groupTypeAsString(), other.groupTypeAsString()) && this.hasPropertyNames() == other.hasPropertyNames() && Objects.equals(this.propertyNames(), other.propertyNames()) && Objects.equals(this.isInherited(), other.isInherited());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyGroupResponse").add("GroupType", (Object)this.groupTypeAsString()).add("PropertyNames", this.hasPropertyNames() ? this.propertyNames() : null).add("IsInherited", (Object)this.isInherited()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupType": {
                return Optional.ofNullable(clazz.cast(this.groupTypeAsString()));
            }
            case "propertyNames": {
                return Optional.ofNullable(clazz.cast(this.propertyNames()));
            }
            case "isInherited": {
                return Optional.ofNullable(clazz.cast(this.isInherited()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyGroupResponse, T> g) {
        return obj -> g.apply((PropertyGroupResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupType;
        private List<String> propertyNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean isInherited;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyGroupResponse model) {
            this.groupType(model.groupType);
            this.propertyNames(model.propertyNames);
            this.isInherited(model.isInherited);
        }

        public final String getGroupType() {
            return this.groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Collection<String> getPropertyNames() {
            if (this.propertyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propertyNames;
        }

        public final void setPropertyNames(Collection<String> propertyNames) {
            this.propertyNames = PropertyNamesCopier.copy(propertyNames);
        }

        @Override
        public final Builder propertyNames(Collection<String> propertyNames) {
            this.propertyNames = PropertyNamesCopier.copy(propertyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyNames(String ... propertyNames) {
            this.propertyNames(Arrays.asList(propertyNames));
            return this;
        }

        public final Boolean getIsInherited() {
            return this.isInherited;
        }

        public final void setIsInherited(Boolean isInherited) {
            this.isInherited = isInherited;
        }

        @Override
        public final Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        public PropertyGroupResponse build() {
            return new PropertyGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyGroupResponse> {
        public Builder groupType(String var1);

        public Builder groupType(GroupType var1);

        public Builder propertyNames(Collection<String> var1);

        public Builder propertyNames(String ... var1);

        public Builder isInherited(Boolean var1);
    }
}

