/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.BundleInformation;
import software.amazon.awssdk.services.iottwinmaker.model.PricingMode;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PricingPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PricingPlan> {
    private static final SdkField<Long> BILLABLE_ENTITY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("billableEntityCount").getter(PricingPlan.getter(PricingPlan::billableEntityCount)).setter(PricingPlan.setter(Builder::billableEntityCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billableEntityCount").build()}).build();
    private static final SdkField<BundleInformation> BUNDLE_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bundleInformation").getter(PricingPlan.getter(PricingPlan::bundleInformation)).setter(PricingPlan.setter(Builder::bundleInformation)).constructor(BundleInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleInformation").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("effectiveDateTime").getter(PricingPlan.getter(PricingPlan::effectiveDateTime)).setter(PricingPlan.setter(Builder::effectiveDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveDateTime").build()}).build();
    private static final SdkField<String> PRICING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pricingMode").getter(PricingPlan.getter(PricingPlan::pricingModeAsString)).setter(PricingPlan.setter(Builder::pricingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingMode").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(PricingPlan.getter(PricingPlan::updateDateTime)).setter(PricingPlan.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final SdkField<String> UPDATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReason").getter(PricingPlan.getter(PricingPlan::updateReasonAsString)).setter(PricingPlan.setter(Builder::updateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLABLE_ENTITY_COUNT_FIELD, BUNDLE_INFORMATION_FIELD, EFFECTIVE_DATE_TIME_FIELD, PRICING_MODE_FIELD, UPDATE_DATE_TIME_FIELD, UPDATE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long billableEntityCount;
    private final BundleInformation bundleInformation;
    private final Instant effectiveDateTime;
    private final String pricingMode;
    private final Instant updateDateTime;
    private final String updateReason;

    private PricingPlan(BuilderImpl builder) {
        this.billableEntityCount = builder.billableEntityCount;
        this.bundleInformation = builder.bundleInformation;
        this.effectiveDateTime = builder.effectiveDateTime;
        this.pricingMode = builder.pricingMode;
        this.updateDateTime = builder.updateDateTime;
        this.updateReason = builder.updateReason;
    }

    public final Long billableEntityCount() {
        return this.billableEntityCount;
    }

    public final BundleInformation bundleInformation() {
        return this.bundleInformation;
    }

    public final Instant effectiveDateTime() {
        return this.effectiveDateTime;
    }

    public final PricingMode pricingMode() {
        return PricingMode.fromValue(this.pricingMode);
    }

    public final String pricingModeAsString() {
        return this.pricingMode;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public final UpdateReason updateReason() {
        return UpdateReason.fromValue(this.updateReason);
    }

    public final String updateReasonAsString() {
        return this.updateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.billableEntityCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PricingPlan)) {
            return false;
        }
        PricingPlan other = (PricingPlan)obj;
        return Objects.equals(this.billableEntityCount(), other.billableEntityCount()) && Objects.equals(this.bundleInformation(), other.bundleInformation()) && Objects.equals(this.effectiveDateTime(), other.effectiveDateTime()) && Objects.equals(this.pricingModeAsString(), other.pricingModeAsString()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.updateReasonAsString(), other.updateReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PricingPlan").add("BillableEntityCount", (Object)this.billableEntityCount()).add("BundleInformation", (Object)this.bundleInformation()).add("EffectiveDateTime", (Object)this.effectiveDateTime()).add("PricingMode", (Object)this.pricingModeAsString()).add("UpdateDateTime", (Object)this.updateDateTime()).add("UpdateReason", (Object)this.updateReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billableEntityCount": {
                return Optional.ofNullable(clazz.cast(this.billableEntityCount()));
            }
            case "bundleInformation": {
                return Optional.ofNullable(clazz.cast(this.bundleInformation()));
            }
            case "effectiveDateTime": {
                return Optional.ofNullable(clazz.cast(this.effectiveDateTime()));
            }
            case "pricingMode": {
                return Optional.ofNullable(clazz.cast(this.pricingModeAsString()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "updateReason": {
                return Optional.ofNullable(clazz.cast(this.updateReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PricingPlan, T> g) {
        return obj -> g.apply((PricingPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long billableEntityCount;
        private BundleInformation bundleInformation;
        private Instant effectiveDateTime;
        private String pricingMode;
        private Instant updateDateTime;
        private String updateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(PricingPlan model) {
            this.billableEntityCount(model.billableEntityCount);
            this.bundleInformation(model.bundleInformation);
            this.effectiveDateTime(model.effectiveDateTime);
            this.pricingMode(model.pricingMode);
            this.updateDateTime(model.updateDateTime);
            this.updateReason(model.updateReason);
        }

        public final Long getBillableEntityCount() {
            return this.billableEntityCount;
        }

        public final void setBillableEntityCount(Long billableEntityCount) {
            this.billableEntityCount = billableEntityCount;
        }

        @Override
        public final Builder billableEntityCount(Long billableEntityCount) {
            this.billableEntityCount = billableEntityCount;
            return this;
        }

        public final BundleInformation.Builder getBundleInformation() {
            return this.bundleInformation != null ? this.bundleInformation.toBuilder() : null;
        }

        public final void setBundleInformation(BundleInformation.BuilderImpl bundleInformation) {
            this.bundleInformation = bundleInformation != null ? bundleInformation.build() : null;
        }

        @Override
        public final Builder bundleInformation(BundleInformation bundleInformation) {
            this.bundleInformation = bundleInformation;
            return this;
        }

        public final Instant getEffectiveDateTime() {
            return this.effectiveDateTime;
        }

        public final void setEffectiveDateTime(Instant effectiveDateTime) {
            this.effectiveDateTime = effectiveDateTime;
        }

        @Override
        public final Builder effectiveDateTime(Instant effectiveDateTime) {
            this.effectiveDateTime = effectiveDateTime;
            return this;
        }

        public final String getPricingMode() {
            return this.pricingMode;
        }

        public final void setPricingMode(String pricingMode) {
            this.pricingMode = pricingMode;
        }

        @Override
        public final Builder pricingMode(String pricingMode) {
            this.pricingMode = pricingMode;
            return this;
        }

        @Override
        public final Builder pricingMode(PricingMode pricingMode) {
            this.pricingMode(pricingMode == null ? null : pricingMode.toString());
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getUpdateReason() {
            return this.updateReason;
        }

        public final void setUpdateReason(String updateReason) {
            this.updateReason = updateReason;
        }

        @Override
        public final Builder updateReason(String updateReason) {
            this.updateReason = updateReason;
            return this;
        }

        @Override
        public final Builder updateReason(UpdateReason updateReason) {
            this.updateReason(updateReason == null ? null : updateReason.toString());
            return this;
        }

        public PricingPlan build() {
            return new PricingPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PricingPlan> {
        public Builder billableEntityCount(Long var1);

        public Builder bundleInformation(BundleInformation var1);

        default public Builder bundleInformation(Consumer<BundleInformation.Builder> bundleInformation) {
            return this.bundleInformation((BundleInformation)((BundleInformation.Builder)BundleInformation.builder().applyMutation(bundleInformation)).build());
        }

        public Builder effectiveDateTime(Instant var1);

        public Builder pricingMode(String var1);

        public Builder pricingMode(PricingMode var1);

        public Builder updateDateTime(Instant var1);

        public Builder updateReason(String var1);

        public Builder updateReason(UpdateReason var1);
    }
}

