/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse;

public class ListScenesIterable
implements SdkIterable<ListScenesResponse> {
    private final IoTTwinMakerClient client;
    private final ListScenesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScenesIterable(IoTTwinMakerClient client, ListScenesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListScenesResponseFetcher();
    }

    public Iterator<ListScenesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListScenesResponseFetcher
    implements SyncPageFetcher<ListScenesResponse> {
        private ListScenesResponseFetcher() {
        }

        public boolean hasNextPage(ListScenesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScenesResponse nextPage(ListScenesResponse previousPage) {
            if (previousPage == null) {
                return ListScenesIterable.this.client.listScenes(ListScenesIterable.this.firstRequest);
            }
            return ListScenesIterable.this.client.listScenes((ListScenesRequest)((Object)ListScenesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

