/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequestsCopier;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompositeComponentUpdateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompositeComponentUpdateRequest> {
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateType").getter(CompositeComponentUpdateRequest.getter(CompositeComponentUpdateRequest::updateTypeAsString)).setter(CompositeComponentUpdateRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CompositeComponentUpdateRequest.getter(CompositeComponentUpdateRequest::description)).setter(CompositeComponentUpdateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, PropertyRequest>> PROPERTY_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyUpdates").getter(CompositeComponentUpdateRequest.getter(CompositeComponentUpdateRequest::propertyUpdates)).setter(CompositeComponentUpdateRequest.setter(Builder::propertyUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyUpdates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentPropertyGroupRequest>> PROPERTY_GROUP_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyGroupUpdates").getter(CompositeComponentUpdateRequest.getter(CompositeComponentUpdateRequest::propertyGroupUpdates)).setter(CompositeComponentUpdateRequest.setter(Builder::propertyGroupUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroupUpdates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentPropertyGroupRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TYPE_FIELD, DESCRIPTION_FIELD, PROPERTY_UPDATES_FIELD, PROPERTY_GROUP_UPDATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String updateType;
    private final String description;
    private final Map<String, PropertyRequest> propertyUpdates;
    private final Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates;

    private CompositeComponentUpdateRequest(BuilderImpl builder) {
        this.updateType = builder.updateType;
        this.description = builder.description;
        this.propertyUpdates = builder.propertyUpdates;
        this.propertyGroupUpdates = builder.propertyGroupUpdates;
    }

    public final ComponentUpdateType updateType() {
        return ComponentUpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPropertyUpdates() {
        return this.propertyUpdates != null && !(this.propertyUpdates instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyRequest> propertyUpdates() {
        return this.propertyUpdates;
    }

    public final boolean hasPropertyGroupUpdates() {
        return this.propertyGroupUpdates != null && !(this.propertyGroupUpdates instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates() {
        return this.propertyGroupUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyUpdates() ? this.propertyUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyGroupUpdates() ? this.propertyGroupUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeComponentUpdateRequest)) {
            return false;
        }
        CompositeComponentUpdateRequest other = (CompositeComponentUpdateRequest)obj;
        return Objects.equals(this.updateTypeAsString(), other.updateTypeAsString()) && Objects.equals(this.description(), other.description()) && this.hasPropertyUpdates() == other.hasPropertyUpdates() && Objects.equals(this.propertyUpdates(), other.propertyUpdates()) && this.hasPropertyGroupUpdates() == other.hasPropertyGroupUpdates() && Objects.equals(this.propertyGroupUpdates(), other.propertyGroupUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"CompositeComponentUpdateRequest").add("UpdateType", (Object)this.updateTypeAsString()).add("Description", (Object)this.description()).add("PropertyUpdates", this.hasPropertyUpdates() ? this.propertyUpdates() : null).add("PropertyGroupUpdates", this.hasPropertyGroupUpdates() ? this.propertyGroupUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "updateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "propertyUpdates": {
                return Optional.ofNullable(clazz.cast(this.propertyUpdates()));
            }
            case "propertyGroupUpdates": {
                return Optional.ofNullable(clazz.cast(this.propertyGroupUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompositeComponentUpdateRequest, T> g) {
        return obj -> g.apply((CompositeComponentUpdateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String updateType;
        private String description;
        private Map<String, PropertyRequest> propertyUpdates = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeComponentUpdateRequest model) {
            this.updateType(model.updateType);
            this.description(model.description);
            this.propertyUpdates(model.propertyUpdates);
            this.propertyGroupUpdates(model.propertyGroupUpdates);
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(ComponentUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyRequest.Builder> getPropertyUpdates() {
            Map<String, PropertyRequest.Builder> result = PropertyRequestsCopier.copyToBuilder(this.propertyUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyUpdates(Map<String, PropertyRequest.BuilderImpl> propertyUpdates) {
            this.propertyUpdates = PropertyRequestsCopier.copyFromBuilder(propertyUpdates);
        }

        @Override
        public final Builder propertyUpdates(Map<String, PropertyRequest> propertyUpdates) {
            this.propertyUpdates = PropertyRequestsCopier.copy(propertyUpdates);
            return this;
        }

        public final Map<String, ComponentPropertyGroupRequest.Builder> getPropertyGroupUpdates() {
            Map<String, ComponentPropertyGroupRequest.Builder> result = ComponentPropertyGroupRequestsCopier.copyToBuilder(this.propertyGroupUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroupUpdates(Map<String, ComponentPropertyGroupRequest.BuilderImpl> propertyGroupUpdates) {
            this.propertyGroupUpdates = ComponentPropertyGroupRequestsCopier.copyFromBuilder(propertyGroupUpdates);
        }

        @Override
        public final Builder propertyGroupUpdates(Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates) {
            this.propertyGroupUpdates = ComponentPropertyGroupRequestsCopier.copy(propertyGroupUpdates);
            return this;
        }

        public CompositeComponentUpdateRequest build() {
            return new CompositeComponentUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompositeComponentUpdateRequest> {
        public Builder updateType(String var1);

        public Builder updateType(ComponentUpdateType var1);

        public Builder description(String var1);

        public Builder propertyUpdates(Map<String, PropertyRequest> var1);

        public Builder propertyGroupUpdates(Map<String, ComponentPropertyGroupRequest> var1);
    }
}

