/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse;

public class GetPropertyValueIterable
implements SdkIterable<GetPropertyValueResponse> {
    private final IoTTwinMakerClient client;
    private final GetPropertyValueRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPropertyValueIterable(IoTTwinMakerClient client, GetPropertyValueRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetPropertyValueResponseFetcher();
    }

    public Iterator<GetPropertyValueResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetPropertyValueResponseFetcher
    implements SyncPageFetcher<GetPropertyValueResponse> {
        private GetPropertyValueResponseFetcher() {
        }

        public boolean hasNextPage(GetPropertyValueResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetPropertyValueResponse nextPage(GetPropertyValueResponse previousPage) {
            if (previousPage == null) {
                return GetPropertyValueIterable.this.client.getPropertyValue(GetPropertyValueIterable.this.firstRequest);
            }
            return GetPropertyValueIterable.this.client.getPropertyValue((GetPropertyValueRequest)((Object)GetPropertyValueIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

