/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ExternalIdPropertyCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityPropertyReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityPropertyReference> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(EntityPropertyReference.getter(EntityPropertyReference::componentName)).setter(EntityPropertyReference.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<Map<String, String>> EXTERNAL_ID_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("externalIdProperty").getter(EntityPropertyReference.getter(EntityPropertyReference::externalIdProperty)).setter(EntityPropertyReference.setter(Builder::externalIdProperty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIdProperty").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(EntityPropertyReference.getter(EntityPropertyReference::entityId)).setter(EntityPropertyReference.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyName").getter(EntityPropertyReference.getter(EntityPropertyReference::propertyName)).setter(EntityPropertyReference.setter(Builder::propertyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, EXTERNAL_ID_PROPERTY_FIELD, ENTITY_ID_FIELD, PROPERTY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final Map<String, String> externalIdProperty;
    private final String entityId;
    private final String propertyName;

    private EntityPropertyReference(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.externalIdProperty = builder.externalIdProperty;
        this.entityId = builder.entityId;
        this.propertyName = builder.propertyName;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final boolean hasExternalIdProperty() {
        return this.externalIdProperty != null && !(this.externalIdProperty instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> externalIdProperty() {
        return this.externalIdProperty;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalIdProperty() ? this.externalIdProperty() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityPropertyReference)) {
            return false;
        }
        EntityPropertyReference other = (EntityPropertyReference)obj;
        return Objects.equals(this.componentName(), other.componentName()) && this.hasExternalIdProperty() == other.hasExternalIdProperty() && Objects.equals(this.externalIdProperty(), other.externalIdProperty()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.propertyName(), other.propertyName());
    }

    public final String toString() {
        return ToString.builder((String)"EntityPropertyReference").add("ComponentName", (Object)this.componentName()).add("ExternalIdProperty", this.hasExternalIdProperty() ? this.externalIdProperty() : null).add("EntityId", (Object)this.entityId()).add("PropertyName", (Object)this.propertyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "externalIdProperty": {
                return Optional.ofNullable(clazz.cast(this.externalIdProperty()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "propertyName": {
                return Optional.ofNullable(clazz.cast(this.propertyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityPropertyReference, T> g) {
        return obj -> g.apply((EntityPropertyReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private Map<String, String> externalIdProperty = DefaultSdkAutoConstructMap.getInstance();
        private String entityId;
        private String propertyName;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityPropertyReference model) {
            this.componentName(model.componentName);
            this.externalIdProperty(model.externalIdProperty);
            this.entityId(model.entityId);
            this.propertyName(model.propertyName);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final Map<String, String> getExternalIdProperty() {
            if (this.externalIdProperty instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.externalIdProperty;
        }

        public final void setExternalIdProperty(Map<String, String> externalIdProperty) {
            this.externalIdProperty = ExternalIdPropertyCopier.copy(externalIdProperty);
        }

        @Override
        public final Builder externalIdProperty(Map<String, String> externalIdProperty) {
            this.externalIdProperty = ExternalIdPropertyCopier.copy(externalIdProperty);
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getPropertyName() {
            return this.propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public EntityPropertyReference build() {
            return new EntityPropertyReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityPropertyReference> {
        public Builder componentName(String var1);

        public Builder externalIdProperty(Map<String, String> var1);

        public Builder entityId(String var1);

        public Builder propertyName(String var1);
    }
}

