/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateReason {
    DEFAULT("DEFAULT"),
    PRICING_TIER_UPDATE("PRICING_TIER_UPDATE"),
    ENTITY_COUNT_UPDATE("ENTITY_COUNT_UPDATE"),
    PRICING_MODE_UPDATE("PRICING_MODE_UPDATE"),
    OVERWRITTEN("OVERWRITTEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateReason> VALUE_MAP;
    private final String value;

    private UpdateReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateReason> knownValues() {
        EnumSet<UpdateReason> knownValues = EnumSet.allOf(UpdateReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateReason.class, UpdateReason::toString);
    }
}

