/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse;

public class ListSyncResourcesIterable
implements SdkIterable<ListSyncResourcesResponse> {
    private final IoTTwinMakerClient client;
    private final ListSyncResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSyncResourcesIterable(IoTTwinMakerClient client, ListSyncResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSyncResourcesResponseFetcher();
    }

    public Iterator<ListSyncResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSyncResourcesResponseFetcher
    implements SyncPageFetcher<ListSyncResourcesResponse> {
        private ListSyncResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListSyncResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSyncResourcesResponse nextPage(ListSyncResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListSyncResourcesIterable.this.client.listSyncResources(ListSyncResourcesIterable.this.firstRequest);
            }
            return ListSyncResourcesIterable.this.client.listSyncResources((ListSyncResourcesRequest)((Object)ListSyncResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

