/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iottwinmaker.DefaultIoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.DefaultIoTTwinMakerBaseClientBuilder;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClientBuilder;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerServiceClientConfiguration;
import software.amazon.awssdk.services.iottwinmaker.endpoints.IoTTwinMakerEndpointProvider;

@SdkInternalApi
final class DefaultIoTTwinMakerAsyncClientBuilder
extends DefaultIoTTwinMakerBaseClientBuilder<IoTTwinMakerAsyncClientBuilder, IoTTwinMakerAsyncClient>
implements IoTTwinMakerAsyncClientBuilder {
    DefaultIoTTwinMakerAsyncClientBuilder() {
    }

    @Override
    public DefaultIoTTwinMakerAsyncClientBuilder endpointProvider(IoTTwinMakerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTTwinMakerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIoTTwinMakerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IoTTwinMakerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIoTTwinMakerAsyncClient client = new DefaultIoTTwinMakerAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IoTTwinMakerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IoTTwinMakerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

