/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the pricing bundle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BundleInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<BundleInformation.Builder, BundleInformation> {
    private static final SdkField<List<String>> BUNDLE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("bundleNames")
            .getter(getter(BundleInformation::bundleNames))
            .setter(setter(Builder::bundleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRICING_TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pricingTier").getter(getter(BundleInformation::pricingTierAsString))
            .setter(setter(Builder::pricingTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingTier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_NAMES_FIELD,
            PRICING_TIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> bundleNames;

    private final String pricingTier;

    private BundleInformation(BuilderImpl builder) {
        this.bundleNames = builder.bundleNames;
        this.pricingTier = builder.pricingTier;
    }

    /**
     * For responses, this returns true if the service returned a value for the BundleNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBundleNames() {
        return bundleNames != null && !(bundleNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The bundle names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBundleNames} method.
     * </p>
     * 
     * @return The bundle names.
     */
    public final List<String> bundleNames() {
        return bundleNames;
    }

    /**
     * <p>
     * The pricing tier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingTier} will
     * return {@link PricingTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingTierAsString}.
     * </p>
     * 
     * @return The pricing tier.
     * @see PricingTier
     */
    public final PricingTier pricingTier() {
        return PricingTier.fromValue(pricingTier);
    }

    /**
     * <p>
     * The pricing tier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingTier} will
     * return {@link PricingTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingTierAsString}.
     * </p>
     * 
     * @return The pricing tier.
     * @see PricingTier
     */
    public final String pricingTierAsString() {
        return pricingTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBundleNames() ? bundleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pricingTierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInformation)) {
            return false;
        }
        BundleInformation other = (BundleInformation) obj;
        return hasBundleNames() == other.hasBundleNames() && Objects.equals(bundleNames(), other.bundleNames())
                && Objects.equals(pricingTierAsString(), other.pricingTierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BundleInformation").add("BundleNames", hasBundleNames() ? bundleNames() : null)
                .add("PricingTier", pricingTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundleNames":
            return Optional.ofNullable(clazz.cast(bundleNames()));
        case "pricingTier":
            return Optional.ofNullable(clazz.cast(pricingTierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BundleInformation, T> g) {
        return obj -> g.apply((BundleInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BundleInformation> {
        /**
         * <p>
         * The bundle names.
         * </p>
         * 
         * @param bundleNames
         *        The bundle names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleNames(Collection<String> bundleNames);

        /**
         * <p>
         * The bundle names.
         * </p>
         * 
         * @param bundleNames
         *        The bundle names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleNames(String... bundleNames);

        /**
         * <p>
         * The pricing tier.
         * </p>
         * 
         * @param pricingTier
         *        The pricing tier.
         * @see PricingTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingTier
         */
        Builder pricingTier(String pricingTier);

        /**
         * <p>
         * The pricing tier.
         * </p>
         * 
         * @param pricingTier
         *        The pricing tier.
         * @see PricingTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingTier
         */
        Builder pricingTier(PricingTier pricingTier);
    }

    static final class BuilderImpl implements Builder {
        private List<String> bundleNames = DefaultSdkAutoConstructList.getInstance();

        private String pricingTier;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleInformation model) {
            bundleNames(model.bundleNames);
            pricingTier(model.pricingTier);
        }

        public final Collection<String> getBundleNames() {
            if (bundleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return bundleNames;
        }

        public final void setBundleNames(Collection<String> bundleNames) {
            this.bundleNames = PricingBundlesCopier.copy(bundleNames);
        }

        @Override
        public final Builder bundleNames(Collection<String> bundleNames) {
            this.bundleNames = PricingBundlesCopier.copy(bundleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleNames(String... bundleNames) {
            bundleNames(Arrays.asList(bundleNames));
            return this;
        }

        public final String getPricingTier() {
            return pricingTier;
        }

        public final void setPricingTier(String pricingTier) {
            this.pricingTier = pricingTier;
        }

        @Override
        public final Builder pricingTier(String pricingTier) {
            this.pricingTier = pricingTier;
            return this;
        }

        @Override
        public final Builder pricingTier(PricingTier pricingTier) {
            this.pricingTier(pricingTier == null ? null : pricingTier.toString());
            return this;
        }

        @Override
        public BundleInformation build() {
            return new BundleInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
