/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.InterpolationParameters;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.OrderByTime;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyFiltersCopier;
import software.amazon.awssdk.services.iottwinmaker.model.SelectedPropertyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPropertyValueHistoryRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, GetPropertyValueHistoryRequest> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::componentName)).setter(GetPropertyValueHistoryRequest.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::componentTypeId)).setter(GetPropertyValueHistoryRequest.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDateTime").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::endDateTime)).setter(GetPropertyValueHistoryRequest.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::entityId)).setter(GetPropertyValueHistoryRequest.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<InterpolationParameters> INTERPOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("interpolation").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::interpolation)).setter(GetPropertyValueHistoryRequest.setter(Builder::interpolation)).constructor(InterpolationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpolation").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::maxResults)).setter(GetPropertyValueHistoryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::nextToken)).setter(GetPropertyValueHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> ORDER_BY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orderByTime").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::orderByTimeAsString)).setter(GetPropertyValueHistoryRequest.setter(Builder::orderByTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderByTime").build()}).build();
    private static final SdkField<List<PropertyFilter>> PROPERTY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyFilters").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::propertyFilters)).setter(GetPropertyValueHistoryRequest.setter(Builder::propertyFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELECTED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectedProperties").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::selectedProperties)).setter(GetPropertyValueHistoryRequest.setter(Builder::selectedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDateTime").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::startDateTime)).setter(GetPropertyValueHistoryRequest.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetPropertyValueHistoryRequest.getter(GetPropertyValueHistoryRequest::workspaceId)).setter(GetPropertyValueHistoryRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, COMPONENT_TYPE_ID_FIELD, END_DATE_TIME_FIELD, ENTITY_ID_FIELD, INTERPOLATION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_BY_TIME_FIELD, PROPERTY_FILTERS_FIELD, SELECTED_PROPERTIES_FIELD, START_DATE_TIME_FIELD, WORKSPACE_ID_FIELD));
    private final String componentName;
    private final String componentTypeId;
    private final Instant endDateTime;
    private final String entityId;
    private final InterpolationParameters interpolation;
    private final Integer maxResults;
    private final String nextToken;
    private final String orderByTime;
    private final List<PropertyFilter> propertyFilters;
    private final List<String> selectedProperties;
    private final Instant startDateTime;
    private final String workspaceId;

    private GetPropertyValueHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.componentName = builder.componentName;
        this.componentTypeId = builder.componentTypeId;
        this.endDateTime = builder.endDateTime;
        this.entityId = builder.entityId;
        this.interpolation = builder.interpolation;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.orderByTime = builder.orderByTime;
        this.propertyFilters = builder.propertyFilters;
        this.selectedProperties = builder.selectedProperties;
        this.startDateTime = builder.startDateTime;
        this.workspaceId = builder.workspaceId;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final Instant endDateTime() {
        return this.endDateTime;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final InterpolationParameters interpolation() {
        return this.interpolation;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final OrderByTime orderByTime() {
        return OrderByTime.fromValue(this.orderByTime);
    }

    public final String orderByTimeAsString() {
        return this.orderByTime;
    }

    public final boolean hasPropertyFilters() {
        return this.propertyFilters != null && !(this.propertyFilters instanceof SdkAutoConstructList);
    }

    public final List<PropertyFilter> propertyFilters() {
        return this.propertyFilters;
    }

    public final boolean hasSelectedProperties() {
        return this.selectedProperties != null && !(this.selectedProperties instanceof SdkAutoConstructList);
    }

    public final List<String> selectedProperties() {
        return this.selectedProperties;
    }

    public final Instant startDateTime() {
        return this.startDateTime;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interpolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderByTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyFilters() ? this.propertyFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedProperties() ? this.selectedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueHistoryRequest)) {
            return false;
        }
        GetPropertyValueHistoryRequest other = (GetPropertyValueHistoryRequest)((Object)obj);
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.interpolation(), other.interpolation()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.orderByTimeAsString(), other.orderByTimeAsString()) && this.hasPropertyFilters() == other.hasPropertyFilters() && Objects.equals(this.propertyFilters(), other.propertyFilters()) && this.hasSelectedProperties() == other.hasSelectedProperties() && Objects.equals(this.selectedProperties(), other.selectedProperties()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"GetPropertyValueHistoryRequest").add("ComponentName", (Object)this.componentName()).add("ComponentTypeId", (Object)this.componentTypeId()).add("EndDateTime", (Object)this.endDateTime()).add("EntityId", (Object)this.entityId()).add("Interpolation", (Object)this.interpolation()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OrderByTime", (Object)this.orderByTimeAsString()).add("PropertyFilters", this.hasPropertyFilters() ? this.propertyFilters() : null).add("SelectedProperties", this.hasSelectedProperties() ? this.selectedProperties() : null).add("StartDateTime", (Object)this.startDateTime()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "endDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "interpolation": {
                return Optional.ofNullable(clazz.cast(this.interpolation()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "orderByTime": {
                return Optional.ofNullable(clazz.cast(this.orderByTimeAsString()));
            }
            case "propertyFilters": {
                return Optional.ofNullable(clazz.cast(this.propertyFilters()));
            }
            case "selectedProperties": {
                return Optional.ofNullable(clazz.cast(this.selectedProperties()));
            }
            case "startDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPropertyValueHistoryRequest, T> g) {
        return obj -> g.apply((GetPropertyValueHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String componentName;
        private String componentTypeId;
        private Instant endDateTime;
        private String entityId;
        private InterpolationParameters interpolation;
        private Integer maxResults;
        private String nextToken;
        private String orderByTime;
        private List<PropertyFilter> propertyFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> selectedProperties = DefaultSdkAutoConstructList.getInstance();
        private Instant startDateTime;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertyValueHistoryRequest model) {
            super(model);
            this.componentName(model.componentName);
            this.componentTypeId(model.componentTypeId);
            this.endDateTime(model.endDateTime);
            this.entityId(model.entityId);
            this.interpolation(model.interpolation);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.orderByTime(model.orderByTime);
            this.propertyFilters(model.propertyFilters);
            this.selectedProperties(model.selectedProperties);
            this.startDateTime(model.startDateTime);
            this.workspaceId(model.workspaceId);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final InterpolationParameters.Builder getInterpolation() {
            return this.interpolation != null ? this.interpolation.toBuilder() : null;
        }

        public final void setInterpolation(InterpolationParameters.BuilderImpl interpolation) {
            this.interpolation = interpolation != null ? interpolation.build() : null;
        }

        @Override
        public final Builder interpolation(InterpolationParameters interpolation) {
            this.interpolation = interpolation;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrderByTime() {
            return this.orderByTime;
        }

        public final void setOrderByTime(String orderByTime) {
            this.orderByTime = orderByTime;
        }

        @Override
        public final Builder orderByTime(String orderByTime) {
            this.orderByTime = orderByTime;
            return this;
        }

        @Override
        public final Builder orderByTime(OrderByTime orderByTime) {
            this.orderByTime(orderByTime == null ? null : orderByTime.toString());
            return this;
        }

        public final List<PropertyFilter.Builder> getPropertyFilters() {
            List<PropertyFilter.Builder> result = PropertyFiltersCopier.copyToBuilder(this.propertyFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyFilters(Collection<PropertyFilter.BuilderImpl> propertyFilters) {
            this.propertyFilters = PropertyFiltersCopier.copyFromBuilder(propertyFilters);
        }

        @Override
        public final Builder propertyFilters(Collection<PropertyFilter> propertyFilters) {
            this.propertyFilters = PropertyFiltersCopier.copy(propertyFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyFilters(PropertyFilter ... propertyFilters) {
            this.propertyFilters(Arrays.asList(propertyFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyFilters(Consumer<PropertyFilter.Builder> ... propertyFilters) {
            this.propertyFilters(Stream.of(propertyFilters).map(c -> (PropertyFilter)((PropertyFilter.Builder)PropertyFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSelectedProperties() {
            if (this.selectedProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedProperties;
        }

        public final void setSelectedProperties(Collection<String> selectedProperties) {
            this.selectedProperties = SelectedPropertyListCopier.copy(selectedProperties);
        }

        @Override
        public final Builder selectedProperties(Collection<String> selectedProperties) {
            this.selectedProperties = SelectedPropertyListCopier.copy(selectedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedProperties(String ... selectedProperties) {
            this.selectedProperties(Arrays.asList(selectedProperties));
            return this;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPropertyValueHistoryRequest build() {
            return new GetPropertyValueHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPropertyValueHistoryRequest> {
        public Builder componentName(String var1);

        public Builder componentTypeId(String var1);

        public Builder endDateTime(Instant var1);

        public Builder entityId(String var1);

        public Builder interpolation(InterpolationParameters var1);

        default public Builder interpolation(Consumer<InterpolationParameters.Builder> interpolation) {
            return this.interpolation((InterpolationParameters)((InterpolationParameters.Builder)InterpolationParameters.builder().applyMutation(interpolation)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder orderByTime(String var1);

        public Builder orderByTime(OrderByTime var1);

        public Builder propertyFilters(Collection<PropertyFilter> var1);

        public Builder propertyFilters(PropertyFilter ... var1);

        public Builder propertyFilters(Consumer<PropertyFilter.Builder> ... var1);

        public Builder selectedProperties(Collection<String> var1);

        public Builder selectedProperties(String ... var1);

        public Builder startDateTime(Instant var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

