/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSystemTemplateRequest
extends IoTThingsGraphRequest
implements ToCopyableBuilder<Builder, GetSystemTemplateRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSystemTemplateRequest.getter(GetSystemTemplateRequest::id)).setter(GetSystemTemplateRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Long> REVISION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetSystemTemplateRequest.getter(GetSystemTemplateRequest::revisionNumber)).setter(GetSystemTemplateRequest.setter(Builder::revisionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REVISION_NUMBER_FIELD));
    private final String id;
    private final Long revisionNumber;

    private GetSystemTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.revisionNumber = builder.revisionNumber;
    }

    public String id() {
        return this.id;
    }

    public Long revisionNumber() {
        return this.revisionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSystemTemplateRequest)) {
            return false;
        }
        GetSystemTemplateRequest other = (GetSystemTemplateRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.revisionNumber(), other.revisionNumber());
    }

    public String toString() {
        return ToString.builder((String)"GetSystemTemplateRequest").add("Id", (Object)this.id()).add("RevisionNumber", (Object)this.revisionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "revisionNumber": {
                return Optional.ofNullable(clazz.cast(this.revisionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSystemTemplateRequest, T> g) {
        return obj -> g.apply((GetSystemTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphRequest.BuilderImpl
    implements Builder {
        private String id;
        private Long revisionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSystemTemplateRequest model) {
            super(model);
            this.id(model.id);
            this.revisionNumber(model.revisionNumber);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Long getRevisionNumber() {
            return this.revisionNumber;
        }

        @Override
        public final Builder revisionNumber(Long revisionNumber) {
            this.revisionNumber = revisionNumber;
            return this;
        }

        public final void setRevisionNumber(Long revisionNumber) {
            this.revisionNumber = revisionNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSystemTemplateRequest build() {
            return new GetSystemTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSystemTemplateRequest> {
        public Builder id(String var1);

        public Builder revisionNumber(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

