/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNamespaceResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, DescribeNamespaceResponse> {
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceArn").getter(DescribeNamespaceResponse.getter(DescribeNamespaceResponse::namespaceArn)).setter(DescribeNamespaceResponse.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(DescribeNamespaceResponse.getter(DescribeNamespaceResponse::namespaceName)).setter(DescribeNamespaceResponse.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> TRACKING_NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackingNamespaceName").getter(DescribeNamespaceResponse.getter(DescribeNamespaceResponse::trackingNamespaceName)).setter(DescribeNamespaceResponse.setter(Builder::trackingNamespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingNamespaceName").build()}).build();
    private static final SdkField<Long> TRACKING_NAMESPACE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("trackingNamespaceVersion").getter(DescribeNamespaceResponse.getter(DescribeNamespaceResponse::trackingNamespaceVersion)).setter(DescribeNamespaceResponse.setter(Builder::trackingNamespaceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingNamespaceVersion").build()}).build();
    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("namespaceVersion").getter(DescribeNamespaceResponse.getter(DescribeNamespaceResponse::namespaceVersion)).setter(DescribeNamespaceResponse.setter(Builder::namespaceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD, TRACKING_NAMESPACE_NAME_FIELD, TRACKING_NAMESPACE_VERSION_FIELD, NAMESPACE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeNamespaceResponse.memberNameToFieldInitializer();
    private final String namespaceArn;
    private final String namespaceName;
    private final String trackingNamespaceName;
    private final Long trackingNamespaceVersion;
    private final Long namespaceVersion;

    private DescribeNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.trackingNamespaceName = builder.trackingNamespaceName;
        this.trackingNamespaceVersion = builder.trackingNamespaceVersion;
        this.namespaceVersion = builder.namespaceVersion;
    }

    public final String namespaceArn() {
        return this.namespaceArn;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String trackingNamespaceName() {
        return this.trackingNamespaceName;
    }

    public final Long trackingNamespaceVersion() {
        return this.trackingNamespaceVersion;
    }

    public final Long namespaceVersion() {
        return this.namespaceVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingNamespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingNamespaceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNamespaceResponse)) {
            return false;
        }
        DescribeNamespaceResponse other = (DescribeNamespaceResponse)((Object)obj);
        return Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.trackingNamespaceName(), other.trackingNamespaceName()) && Objects.equals(this.trackingNamespaceVersion(), other.trackingNamespaceVersion()) && Objects.equals(this.namespaceVersion(), other.namespaceVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNamespaceResponse").add("NamespaceArn", (Object)this.namespaceArn()).add("NamespaceName", (Object)this.namespaceName()).add("TrackingNamespaceName", (Object)this.trackingNamespaceName()).add("TrackingNamespaceVersion", (Object)this.trackingNamespaceVersion()).add("NamespaceVersion", (Object)this.namespaceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "trackingNamespaceName": {
                return Optional.ofNullable(clazz.cast(this.trackingNamespaceName()));
            }
            case "trackingNamespaceVersion": {
                return Optional.ofNullable(clazz.cast(this.trackingNamespaceVersion()));
            }
            case "namespaceVersion": {
                return Optional.ofNullable(clazz.cast(this.namespaceVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespaceArn", NAMESPACE_ARN_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("trackingNamespaceName", TRACKING_NAMESPACE_NAME_FIELD);
        map.put("trackingNamespaceVersion", TRACKING_NAMESPACE_VERSION_FIELD);
        map.put("namespaceVersion", NAMESPACE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNamespaceResponse, T> g) {
        return obj -> g.apply((DescribeNamespaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private String namespaceArn;
        private String namespaceName;
        private String trackingNamespaceName;
        private Long trackingNamespaceVersion;
        private Long namespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNamespaceResponse model) {
            super(model);
            this.namespaceArn(model.namespaceArn);
            this.namespaceName(model.namespaceName);
            this.trackingNamespaceName(model.trackingNamespaceName);
            this.trackingNamespaceVersion(model.trackingNamespaceVersion);
            this.namespaceVersion(model.namespaceVersion);
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getTrackingNamespaceName() {
            return this.trackingNamespaceName;
        }

        public final void setTrackingNamespaceName(String trackingNamespaceName) {
            this.trackingNamespaceName = trackingNamespaceName;
        }

        @Override
        public final Builder trackingNamespaceName(String trackingNamespaceName) {
            this.trackingNamespaceName = trackingNamespaceName;
            return this;
        }

        public final Long getTrackingNamespaceVersion() {
            return this.trackingNamespaceVersion;
        }

        public final void setTrackingNamespaceVersion(Long trackingNamespaceVersion) {
            this.trackingNamespaceVersion = trackingNamespaceVersion;
        }

        @Override
        public final Builder trackingNamespaceVersion(Long trackingNamespaceVersion) {
            this.trackingNamespaceVersion = trackingNamespaceVersion;
            return this;
        }

        public final Long getNamespaceVersion() {
            return this.namespaceVersion;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        @Override
        public DescribeNamespaceResponse build() {
            return new DescribeNamespaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNamespaceResponse> {
        public Builder namespaceArn(String var1);

        public Builder namespaceName(String var1);

        public Builder trackingNamespaceName(String var1);

        public Builder trackingNamespaceVersion(Long var1);

        public Builder namespaceVersion(Long var1);
    }
}

