/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNamespaceResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<DescribeNamespaceResponse.Builder, DescribeNamespaceResponse> {
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceArn").getter(getter(DescribeNamespaceResponse::namespaceArn))
            .setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(DescribeNamespaceResponse::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> TRACKING_NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingNamespaceName").getter(getter(DescribeNamespaceResponse::trackingNamespaceName))
            .setter(setter(Builder::trackingNamespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingNamespaceName").build())
            .build();

    private static final SdkField<Long> TRACKING_NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("trackingNamespaceVersion").getter(getter(DescribeNamespaceResponse::trackingNamespaceVersion))
            .setter(setter(Builder::trackingNamespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingNamespaceVersion").build())
            .build();

    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("namespaceVersion").getter(getter(DescribeNamespaceResponse::namespaceVersion))
            .setter(setter(Builder::namespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_ARN_FIELD,
            NAMESPACE_NAME_FIELD, TRACKING_NAMESPACE_NAME_FIELD, TRACKING_NAMESPACE_VERSION_FIELD, NAMESPACE_VERSION_FIELD));

    private final String namespaceArn;

    private final String namespaceName;

    private final String trackingNamespaceName;

    private final Long trackingNamespaceVersion;

    private final Long namespaceVersion;

    private DescribeNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.trackingNamespaceName = builder.trackingNamespaceName;
        this.trackingNamespaceVersion = builder.trackingNamespaceVersion;
        this.namespaceVersion = builder.namespaceVersion;
    }

    /**
     * <p>
     * The ARN of the namespace.
     * </p>
     * 
     * @return The ARN of the namespace.
     */
    public final String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The name of the namespace.
     * </p>
     * 
     * @return The name of the namespace.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The name of the public namespace that the latest namespace version is tracking.
     * </p>
     * 
     * @return The name of the public namespace that the latest namespace version is tracking.
     */
    public final String trackingNamespaceName() {
        return trackingNamespaceName;
    }

    /**
     * <p>
     * The version of the public namespace that the latest version is tracking.
     * </p>
     * 
     * @return The version of the public namespace that the latest version is tracking.
     */
    public final Long trackingNamespaceVersion() {
        return trackingNamespaceVersion;
    }

    /**
     * <p>
     * The version of the user's namespace to describe.
     * </p>
     * 
     * @return The version of the user's namespace to describe.
     */
    public final Long namespaceVersion() {
        return namespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(trackingNamespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(trackingNamespaceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNamespaceResponse)) {
            return false;
        }
        DescribeNamespaceResponse other = (DescribeNamespaceResponse) obj;
        return Objects.equals(namespaceArn(), other.namespaceArn()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(trackingNamespaceName(), other.trackingNamespaceName())
                && Objects.equals(trackingNamespaceVersion(), other.trackingNamespaceVersion())
                && Objects.equals(namespaceVersion(), other.namespaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNamespaceResponse").add("NamespaceArn", namespaceArn())
                .add("NamespaceName", namespaceName()).add("TrackingNamespaceName", trackingNamespaceName())
                .add("TrackingNamespaceVersion", trackingNamespaceVersion()).add("NamespaceVersion", namespaceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "trackingNamespaceName":
            return Optional.ofNullable(clazz.cast(trackingNamespaceName()));
        case "trackingNamespaceVersion":
            return Optional.ofNullable(clazz.cast(trackingNamespaceVersion()));
        case "namespaceVersion":
            return Optional.ofNullable(clazz.cast(namespaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNamespaceResponse, T> g) {
        return obj -> g.apply((DescribeNamespaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeNamespaceResponse> {
        /**
         * <p>
         * The ARN of the namespace.
         * </p>
         * 
         * @param namespaceArn
         *        The ARN of the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The name of the namespace.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The name of the public namespace that the latest namespace version is tracking.
         * </p>
         * 
         * @param trackingNamespaceName
         *        The name of the public namespace that the latest namespace version is tracking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingNamespaceName(String trackingNamespaceName);

        /**
         * <p>
         * The version of the public namespace that the latest version is tracking.
         * </p>
         * 
         * @param trackingNamespaceVersion
         *        The version of the public namespace that the latest version is tracking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingNamespaceVersion(Long trackingNamespaceVersion);

        /**
         * <p>
         * The version of the user's namespace to describe.
         * </p>
         * 
         * @param namespaceVersion
         *        The version of the user's namespace to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceVersion(Long namespaceVersion);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private String namespaceArn;

        private String namespaceName;

        private String trackingNamespaceName;

        private Long trackingNamespaceVersion;

        private Long namespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNamespaceResponse model) {
            super(model);
            namespaceArn(model.namespaceArn);
            namespaceName(model.namespaceName);
            trackingNamespaceName(model.trackingNamespaceName);
            trackingNamespaceVersion(model.trackingNamespaceVersion);
            namespaceVersion(model.namespaceVersion);
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getTrackingNamespaceName() {
            return trackingNamespaceName;
        }

        public final void setTrackingNamespaceName(String trackingNamespaceName) {
            this.trackingNamespaceName = trackingNamespaceName;
        }

        @Override
        public final Builder trackingNamespaceName(String trackingNamespaceName) {
            this.trackingNamespaceName = trackingNamespaceName;
            return this;
        }

        public final Long getTrackingNamespaceVersion() {
            return trackingNamespaceVersion;
        }

        public final void setTrackingNamespaceVersion(Long trackingNamespaceVersion) {
            this.trackingNamespaceVersion = trackingNamespaceVersion;
        }

        @Override
        public final Builder trackingNamespaceVersion(Long trackingNamespaceVersion) {
            this.trackingNamespaceVersion = trackingNamespaceVersion;
            return this;
        }

        public final Long getNamespaceVersion() {
            return namespaceVersion;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        @Override
        public DescribeNamespaceResponse build() {
            return new DescribeNamespaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
