/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsPublisher;

/**
 * Service client for accessing AWS IoT Things Graph asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS IoT Things Graph</fullname>
 * <p>
 * AWS IoT Things Graph provides an integrated set of tools that enable developers to connect devices and services that
 * use different standards, such as units of measure and communication protocols. AWS IoT Things Graph makes it possible
 * to build IoT applications with little to no code by connecting devices and services and defining how they interact at
 * an abstract level.
 * </p>
 * <p>
 * For more information about how AWS IoT Things Graph works, see the <a
 * href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-whatis.html">User Guide</a>.
 * </p>
 * <p>
 * The AWS IoT Things Graph service is discontinued.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTThingsGraphAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotthingsgraph";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iotthingsgraph";

    /**
     * <p>
     * Associates a device with a concrete thing that is in the user's registry.
     * </p>
     * <p>
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its
     * previous association will be removed.
     * </p>
     *
     * @param associateEntityToThingRequest
     * @return A Java Future containing the result of the AssociateEntityToThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.AssociateEntityToThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<AssociateEntityToThingResponse> associateEntityToThing(
            AssociateEntityToThingRequest associateEntityToThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a device with a concrete thing that is in the user's registry.
     * </p>
     * <p>
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its
     * previous association will be removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEntityToThingRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateEntityToThingRequest#builder()}
     * </p>
     *
     * @param associateEntityToThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateEntityToThingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateEntityToThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.AssociateEntityToThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<AssociateEntityToThingResponse> associateEntityToThing(
            Consumer<AssociateEntityToThingRequest.Builder> associateEntityToThingRequest) {
        return associateEntityToThing(AssociateEntityToThingRequest.builder().applyMutation(associateEntityToThingRequest)
                .build());
    }

    /**
     * <p>
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace
     * contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is
     * validated against the entities in the latest version of the user's namespace unless another namespace version is
     * specified in the request.
     * </p>
     *
     * @param createFlowTemplateRequest
     * @return A Java Future containing the result of the CreateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>LimitExceededException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<CreateFlowTemplateResponse> createFlowTemplate(CreateFlowTemplateRequest createFlowTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace
     * contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is
     * validated against the entities in the latest version of the user's namespace unless another namespace version is
     * specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFlowTemplateRequest#builder()}
     * </p>
     *
     * @param createFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateFlowTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>LimitExceededException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<CreateFlowTemplateResponse> createFlowTemplate(
            Consumer<CreateFlowTemplateRequest.Builder> createFlowTemplateRequest) {
        return createFlowTemplate(CreateFlowTemplateRequest.builder().applyMutation(createFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a system instance.
     * </p>
     * <p>
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments,
     * it updates the Greengrass group that is specified by the <code>greengrassGroupName</code> parameter. It also adds
     * a file to the S3 bucket specified by the <code>s3BucketName</code> parameter. You need to call
     * <code>DeploySystemInstance</code> after running this action.
     * </p>
     * <p>
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket
     * on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group
     * and S3 bucket. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For cloud deployments, this action requires a <code>flowActionsRoleArn</code> value. This is an IAM role that has
     * permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     * </p>
     * <p>
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by
     * default.
     * </p>
     *
     * @param createSystemInstanceRequest
     * @return A Java Future containing the result of the CreateSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>LimitExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<CreateSystemInstanceResponse> createSystemInstance(
            CreateSystemInstanceRequest createSystemInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a system instance.
     * </p>
     * <p>
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments,
     * it updates the Greengrass group that is specified by the <code>greengrassGroupName</code> parameter. It also adds
     * a file to the S3 bucket specified by the <code>s3BucketName</code> parameter. You need to call
     * <code>DeploySystemInstance</code> after running this action.
     * </p>
     * <p>
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket
     * on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group
     * and S3 bucket. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For cloud deployments, this action requires a <code>flowActionsRoleArn</code> value. This is an IAM role that has
     * permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     * </p>
     * <p>
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by
     * default.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSystemInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSystemInstanceRequest#builder()}
     * </p>
     *
     * @param createSystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateSystemInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>LimitExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<CreateSystemInstanceResponse> createSystemInstance(
            Consumer<CreateSystemInstanceRequest.Builder> createSystemInstanceRequest) {
        return createSystemInstance(CreateSystemInstanceRequest.builder().applyMutation(createSystemInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace
     * unless another namespace version is specified in the request.
     * </p>
     *
     * @param createSystemTemplateRequest
     * @return A Java Future containing the result of the CreateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<CreateSystemTemplateResponse> createSystemTemplate(
            CreateSystemTemplateRequest createSystemTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace
     * unless another namespace version is specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSystemTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSystemTemplateRequest#builder()}
     * </p>
     *
     * @param createSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateSystemTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<CreateSystemTemplateResponse> createSystemTemplate(
            Consumer<CreateSystemTemplateRequest.Builder> createSystemTemplateRequest) {
        return createSystemTemplate(CreateSystemTemplateRequest.builder().applyMutation(createSystemTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy.
     * Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow
     * taken at the time of deployment).
     * </p>
     *
     * @param deleteFlowTemplateRequest
     * @return A Java Future containing the result of the DeleteFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeleteFlowTemplateResponse> deleteFlowTemplate(DeleteFlowTemplateRequest deleteFlowTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy.
     * Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow
     * taken at the time of deployment).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFlowTemplateRequest#builder()}
     * </p>
     *
     * @param deleteFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFlowTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeleteFlowTemplateResponse> deleteFlowTemplate(
            Consumer<DeleteFlowTemplateRequest.Builder> deleteFlowTemplateRequest) {
        return deleteFlowTemplate(DeleteFlowTemplateRequest.builder().applyMutation(deleteFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and
     * flows that use entities in the namespace before performing this action. This action takes no request parameters.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and
     * flows that use entities in the namespace before performing this action. This action takes no request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(
            Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest) {
        return deleteNamespace(DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can
     * be deleted.
     * </p>
     * <p>
     * Users can create a new system instance that has the same ID as a deleted system instance.
     * </p>
     *
     * @param deleteSystemInstanceRequest
     * @return A Java Future containing the result of the DeleteSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeleteSystemInstanceResponse> deleteSystemInstance(
            DeleteSystemInstanceRequest deleteSystemInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can
     * be deleted.
     * </p>
     * <p>
     * Users can create a new system instance that has the same ID as a deleted system instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSystemInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSystemInstanceRequest#builder()}
     * </p>
     *
     * @param deleteSystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSystemInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeleteSystemInstanceResponse> deleteSystemInstance(
            Consumer<DeleteSystemInstanceRequest.Builder> deleteSystemInstanceRequest) {
        return deleteSystemInstance(DeleteSystemInstanceRequest.builder().applyMutation(deleteSystemInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain
     * the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     * </p>
     *
     * @param deleteSystemTemplateRequest
     * @return A Java Future containing the result of the DeleteSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeleteSystemTemplateResponse> deleteSystemTemplate(
            DeleteSystemTemplateRequest deleteSystemTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain
     * the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSystemTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSystemTemplateRequest#builder()}
     * </p>
     *
     * @param deleteSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSystemTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeleteSystemTemplateResponse> deleteSystemTemplate(
            Consumer<DeleteSystemTemplateRequest.Builder> deleteSystemTemplateRequest) {
        return deleteSystemTemplate(DeleteSystemTemplateRequest.builder().applyMutation(deleteSystemTemplateRequest).build());
    }

    /**
     * <p>
     * <b>Greengrass and Cloud Deployments</b>
     * </p>
     * <p>
     * Deploys the system instance to the target specified in <code>CreateSystemInstance</code>.
     * </p>
     * <p>
     * <b>Greengrass Deployments</b>
     * </p>
     * <p>
     * If the system or any workflows and entities have been updated before this action is called, then the deployment
     * will create a new Amazon Simple Storage Service resource file and then deploy it.
     * </p>
     * <p>
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write
     * permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see <a
     * href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html">AWS IoT Things Graph and AWS IoT
     * Greengrass</a>.
     * </p>
     *
     * @param deploySystemInstanceRequest
     * @return A Java Future containing the result of the DeploySystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeploySystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeploySystemInstanceResponse> deploySystemInstance(
            DeploySystemInstanceRequest deploySystemInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>Greengrass and Cloud Deployments</b>
     * </p>
     * <p>
     * Deploys the system instance to the target specified in <code>CreateSystemInstance</code>.
     * </p>
     * <p>
     * <b>Greengrass Deployments</b>
     * </p>
     * <p>
     * If the system or any workflows and entities have been updated before this action is called, then the deployment
     * will create a new Amazon Simple Storage Service resource file and then deploy it.
     * </p>
     * <p>
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write
     * permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see <a
     * href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html">AWS IoT Things Graph and AWS IoT
     * Greengrass</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeploySystemInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeploySystemInstanceRequest#builder()}
     * </p>
     *
     * @param deploySystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeploySystemInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeploySystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeploySystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeploySystemInstanceResponse> deploySystemInstance(
            Consumer<DeploySystemInstanceRequest.Builder> deploySystemInstanceRequest) {
        return deploySystemInstance(DeploySystemInstanceRequest.builder().applyMutation(deploySystemInstanceRequest).build());
    }

    /**
     * <p>
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be
     * deployed, but existing deployments will continue to run.
     * </p>
     *
     * @param deprecateFlowTemplateRequest
     * @return A Java Future containing the result of the DeprecateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeprecateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeprecateFlowTemplateResponse> deprecateFlowTemplate(
            DeprecateFlowTemplateRequest deprecateFlowTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be
     * deployed, but existing deployments will continue to run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateFlowTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeprecateFlowTemplateRequest#builder()}
     * </p>
     *
     * @param deprecateFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeprecateFlowTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeprecateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeprecateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeprecateFlowTemplateResponse> deprecateFlowTemplate(
            Consumer<DeprecateFlowTemplateRequest.Builder> deprecateFlowTemplateRequest) {
        return deprecateFlowTemplate(DeprecateFlowTemplateRequest.builder().applyMutation(deprecateFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Deprecates the specified system.
     * </p>
     *
     * @param deprecateSystemTemplateRequest
     * @return A Java Future containing the result of the DeprecateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeprecateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeprecateSystemTemplateResponse> deprecateSystemTemplate(
            DeprecateSystemTemplateRequest deprecateSystemTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates the specified system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateSystemTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeprecateSystemTemplateRequest#builder()}
     * </p>
     *
     * @param deprecateSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeprecateSystemTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeprecateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeprecateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DeprecateSystemTemplateResponse> deprecateSystemTemplate(
            Consumer<DeprecateSystemTemplateRequest.Builder> deprecateSystemTemplateRequest) {
        return deprecateSystemTemplate(DeprecateSystemTemplateRequest.builder().applyMutation(deprecateSystemTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     * </p>
     *
     * @param describeNamespaceRequest
     * @return A Java Future containing the result of the DescribeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DescribeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DescribeNamespaceResponse> describeNamespace(DescribeNamespaceRequest describeNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeNamespaceRequest#builder()}
     * </p>
     *
     * @param describeNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DescribeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DescribeNamespaceResponse> describeNamespace(
            Consumer<DescribeNamespaceRequest.Builder> describeNamespaceRequest) {
        return describeNamespace(DescribeNamespaceRequest.builder().applyMutation(describeNamespaceRequest).build());
    }

    /**
     * <p>
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to
     * dissociate because only one entity of a particular type can be associated with a thing.
     * </p>
     *
     * @param dissociateEntityFromThingRequest
     * @return A Java Future containing the result of the DissociateEntityFromThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DissociateEntityFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DissociateEntityFromThingResponse> dissociateEntityFromThing(
            DissociateEntityFromThingRequest dissociateEntityFromThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to
     * dissociate because only one entity of a particular type can be associated with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DissociateEntityFromThingRequest.Builder} avoiding
     * the need to create one manually via {@link DissociateEntityFromThingRequest#builder()}
     * </p>
     *
     * @param dissociateEntityFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DissociateEntityFromThingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DissociateEntityFromThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DissociateEntityFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<DissociateEntityFromThingResponse> dissociateEntityFromThing(
            Consumer<DissociateEntityFromThingRequest.Builder> dissociateEntityFromThingRequest) {
        return dissociateEntityFromThing(DissociateEntityFromThingRequest.builder()
                .applyMutation(dissociateEntityFromThingRequest).build());
    }

    /**
     * <p>
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API
     * returns the following TDM entities.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Properties
     * </p>
     * </li>
     * <li>
     * <p>
     * States
     * </p>
     * </li>
     * <li>
     * <p>
     * Events
     * </p>
     * </li>
     * <li>
     * <p>
     * Actions
     * </p>
     * </li>
     * <li>
     * <p>
     * Capabilities
     * </p>
     * </li>
     * <li>
     * <p>
     * Mappings
     * </p>
     * </li>
     * <li>
     * <p>
     * Devices
     * </p>
     * </li>
     * <li>
     * <p>
     * Device Models
     * </p>
     * </li>
     * <li>
     * <p>
     * Services
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action doesn't return definitions for systems, flows, and deployments.
     * </p>
     *
     * @param getEntitiesRequest
     * @return A Java Future containing the result of the GetEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetEntities" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetEntitiesResponse> getEntities(GetEntitiesRequest getEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API
     * returns the following TDM entities.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Properties
     * </p>
     * </li>
     * <li>
     * <p>
     * States
     * </p>
     * </li>
     * <li>
     * <p>
     * Events
     * </p>
     * </li>
     * <li>
     * <p>
     * Actions
     * </p>
     * </li>
     * <li>
     * <p>
     * Capabilities
     * </p>
     * </li>
     * <li>
     * <p>
     * Mappings
     * </p>
     * </li>
     * <li>
     * <p>
     * Devices
     * </p>
     * </li>
     * <li>
     * <p>
     * Device Models
     * </p>
     * </li>
     * <li>
     * <p>
     * Services
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action doesn't return definitions for systems, flows, and deployments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEntitiesRequest#builder()}
     * </p>
     *
     * @param getEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link GetEntitiesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetEntities" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetEntitiesResponse> getEntities(Consumer<GetEntitiesRequest.Builder> getEntitiesRequest) {
        return getEntities(GetEntitiesRequest.builder().applyMutation(getEntitiesRequest).build());
    }

    /**
     * <p>
     * Gets the latest version of the <code>DefinitionDocument</code> and <code>FlowTemplateSummary</code> for the
     * specified workflow.
     * </p>
     *
     * @param getFlowTemplateRequest
     * @return A Java Future containing the result of the GetFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetFlowTemplateResponse> getFlowTemplate(GetFlowTemplateRequest getFlowTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the latest version of the <code>DefinitionDocument</code> and <code>FlowTemplateSummary</code> for the
     * specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetFlowTemplateRequest#builder()}
     * </p>
     *
     * @param getFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetFlowTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetFlowTemplateResponse> getFlowTemplate(
            Consumer<GetFlowTemplateRequest.Builder> getFlowTemplateRequest) {
        return getFlowTemplate(GetFlowTemplateRequest.builder().applyMutation(getFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     * @return A Java Future containing the result of the GetFlowTemplateRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetFlowTemplateRevisionsResponse> getFlowTemplateRevisions(
            GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowTemplateRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetFlowTemplateRevisionsRequest#builder()}
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link GetFlowTemplateRevisionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFlowTemplateRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetFlowTemplateRevisionsResponse> getFlowTemplateRevisions(
            Consumer<GetFlowTemplateRevisionsRequest.Builder> getFlowTemplateRevisionsRequest) {
        return getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest.builder().applyMutation(getFlowTemplateRevisionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsPublisher publisher = client.getFlowTemplateRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsPublisher publisher = client.getFlowTemplateRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default GetFlowTemplateRevisionsPublisher getFlowTemplateRevisionsPaginator(
            GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) {
        return new GetFlowTemplateRevisionsPublisher(this, getFlowTemplateRevisionsRequest);
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsPublisher publisher = client.getFlowTemplateRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsPublisher publisher = client.getFlowTemplateRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowTemplateRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetFlowTemplateRevisionsRequest#builder()}
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link GetFlowTemplateRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default GetFlowTemplateRevisionsPublisher getFlowTemplateRevisionsPaginator(
            Consumer<GetFlowTemplateRevisionsRequest.Builder> getFlowTemplateRevisionsRequest) {
        return getFlowTemplateRevisionsPaginator(GetFlowTemplateRevisionsRequest.builder()
                .applyMutation(getFlowTemplateRevisionsRequest).build());
    }

    /**
     * <p>
     * Gets the status of a namespace deletion task.
     * </p>
     *
     * @param getNamespaceDeletionStatusRequest
     * @return A Java Future containing the result of the GetNamespaceDeletionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetNamespaceDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetNamespaceDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetNamespaceDeletionStatusResponse> getNamespaceDeletionStatus(
            GetNamespaceDeletionStatusRequest getNamespaceDeletionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a namespace deletion task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNamespaceDeletionStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetNamespaceDeletionStatusRequest#builder()}
     * </p>
     *
     * @param getNamespaceDeletionStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetNamespaceDeletionStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNamespaceDeletionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetNamespaceDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetNamespaceDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetNamespaceDeletionStatusResponse> getNamespaceDeletionStatus(
            Consumer<GetNamespaceDeletionStatusRequest.Builder> getNamespaceDeletionStatusRequest) {
        return getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest.builder()
                .applyMutation(getNamespaceDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Gets a system instance.
     * </p>
     *
     * @param getSystemInstanceRequest
     * @return A Java Future containing the result of the GetSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetSystemInstanceResponse> getSystemInstance(GetSystemInstanceRequest getSystemInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a system instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSystemInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetSystemInstanceRequest#builder()}
     * </p>
     *
     * @param getSystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetSystemInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetSystemInstanceResponse> getSystemInstance(
            Consumer<GetSystemInstanceRequest.Builder> getSystemInstanceRequest) {
        return getSystemInstance(GetSystemInstanceRequest.builder().applyMutation(getSystemInstanceRequest).build());
    }

    /**
     * <p>
     * Gets a system.
     * </p>
     *
     * @param getSystemTemplateRequest
     * @return A Java Future containing the result of the GetSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetSystemTemplateResponse> getSystemTemplate(GetSystemTemplateRequest getSystemTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSystemTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetSystemTemplateRequest#builder()}
     * </p>
     *
     * @param getSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetSystemTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetSystemTemplateResponse> getSystemTemplate(
            Consumer<GetSystemTemplateRequest.Builder> getSystemTemplateRequest) {
        return getSystemTemplate(GetSystemTemplateRequest.builder().applyMutation(getSystemTemplateRequest).build());
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     * @return A Java Future containing the result of the GetSystemTemplateRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetSystemTemplateRevisionsResponse> getSystemTemplateRevisions(
            GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSystemTemplateRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSystemTemplateRevisionsRequest#builder()}
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link GetSystemTemplateRevisionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSystemTemplateRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetSystemTemplateRevisionsResponse> getSystemTemplateRevisions(
            Consumer<GetSystemTemplateRevisionsRequest.Builder> getSystemTemplateRevisionsRequest) {
        return getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest.builder()
                .applyMutation(getSystemTemplateRevisionsRequest).build());
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsPublisher publisher = client.getSystemTemplateRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsPublisher publisher = client.getSystemTemplateRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default GetSystemTemplateRevisionsPublisher getSystemTemplateRevisionsPaginator(
            GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) {
        return new GetSystemTemplateRevisionsPublisher(this, getSystemTemplateRevisionsRequest);
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsPublisher publisher = client.getSystemTemplateRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsPublisher publisher = client.getSystemTemplateRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSystemTemplateRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSystemTemplateRevisionsRequest#builder()}
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link GetSystemTemplateRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default GetSystemTemplateRevisionsPublisher getSystemTemplateRevisionsPaginator(
            Consumer<GetSystemTemplateRevisionsRequest.Builder> getSystemTemplateRevisionsRequest) {
        return getSystemTemplateRevisionsPaginator(GetSystemTemplateRevisionsRequest.builder()
                .applyMutation(getSystemTemplateRevisionsRequest).build());
    }

    /**
     * <p>
     * Gets the status of the specified upload.
     * </p>
     *
     * @param getUploadStatusRequest
     * @return A Java Future containing the result of the GetUploadStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetUploadStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetUploadStatus"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetUploadStatusResponse> getUploadStatus(GetUploadStatusRequest getUploadStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of the specified upload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUploadStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetUploadStatusRequest#builder()}
     * </p>
     *
     * @param getUploadStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetUploadStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUploadStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetUploadStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetUploadStatus"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<GetUploadStatusResponse> getUploadStatus(
            Consumer<GetUploadStatusRequest.Builder> getUploadStatusRequest) {
        return getUploadStatus(GetUploadStatusRequest.builder().applyMutation(getUploadStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     * @return A Java Future containing the result of the ListFlowExecutionMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListFlowExecutionMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<ListFlowExecutionMessagesResponse> listFlowExecutionMessages(
            ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowExecutionMessagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListFlowExecutionMessagesRequest#builder()}
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     *        A {@link Consumer} that will call methods on {@link ListFlowExecutionMessagesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFlowExecutionMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListFlowExecutionMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<ListFlowExecutionMessagesResponse> listFlowExecutionMessages(
            Consumer<ListFlowExecutionMessagesRequest.Builder> listFlowExecutionMessagesRequest) {
        return listFlowExecutionMessages(ListFlowExecutionMessagesRequest.builder()
                .applyMutation(listFlowExecutionMessagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesPublisher publisher = client.listFlowExecutionMessagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesPublisher publisher = client.listFlowExecutionMessagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListFlowExecutionMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default ListFlowExecutionMessagesPublisher listFlowExecutionMessagesPaginator(
            ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) {
        return new ListFlowExecutionMessagesPublisher(this, listFlowExecutionMessagesRequest);
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesPublisher publisher = client.listFlowExecutionMessagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesPublisher publisher = client.listFlowExecutionMessagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowExecutionMessagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListFlowExecutionMessagesRequest#builder()}
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     *        A {@link Consumer} that will call methods on {@link ListFlowExecutionMessagesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListFlowExecutionMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default ListFlowExecutionMessagesPublisher listFlowExecutionMessagesPaginator(
            Consumer<ListFlowExecutionMessagesRequest.Builder> listFlowExecutionMessagesRequest) {
        return listFlowExecutionMessagesPaginator(ListFlowExecutionMessagesRequest.builder()
                .applyMutation(listFlowExecutionMessagesRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     *
     * @param searchEntitiesRequest
     * @return A Java Future containing the result of the SearchEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchEntitiesResponse> searchEntities(SearchEntitiesRequest searchEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchEntitiesRequest#builder()}
     * </p>
     *
     * @param searchEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link SearchEntitiesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchEntitiesResponse> searchEntities(Consumer<SearchEntitiesRequest.Builder> searchEntitiesRequest) {
        return searchEntities(SearchEntitiesRequest.builder().applyMutation(searchEntitiesRequest).build());
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesPublisher publisher = client.searchEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesPublisher publisher = client.searchEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchEntitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchEntitiesPublisher searchEntitiesPaginator(SearchEntitiesRequest searchEntitiesRequest) {
        return new SearchEntitiesPublisher(this, searchEntitiesRequest);
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesPublisher publisher = client.searchEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesPublisher publisher = client.searchEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchEntitiesRequest#builder()}
     * </p>
     *
     * @param searchEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link SearchEntitiesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchEntitiesPublisher searchEntitiesPaginator(Consumer<SearchEntitiesRequest.Builder> searchEntitiesRequest) {
        return searchEntitiesPaginator(SearchEntitiesRequest.builder().applyMutation(searchEntitiesRequest).build());
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     *
     * @param searchFlowExecutionsRequest
     * @return A Java Future containing the result of the SearchFlowExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchFlowExecutionsResponse> searchFlowExecutions(
            SearchFlowExecutionsRequest searchFlowExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFlowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param searchFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link SearchFlowExecutionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchFlowExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchFlowExecutionsResponse> searchFlowExecutions(
            Consumer<SearchFlowExecutionsRequest.Builder> searchFlowExecutionsRequest) {
        return searchFlowExecutions(SearchFlowExecutionsRequest.builder().applyMutation(searchFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsPublisher publisher = client.searchFlowExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsPublisher publisher = client.searchFlowExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchFlowExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchFlowExecutionsPublisher searchFlowExecutionsPaginator(SearchFlowExecutionsRequest searchFlowExecutionsRequest) {
        return new SearchFlowExecutionsPublisher(this, searchFlowExecutionsRequest);
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsPublisher publisher = client.searchFlowExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsPublisher publisher = client.searchFlowExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFlowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param searchFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link SearchFlowExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchFlowExecutionsPublisher searchFlowExecutionsPaginator(
            Consumer<SearchFlowExecutionsRequest.Builder> searchFlowExecutionsRequest) {
        return searchFlowExecutionsPaginator(SearchFlowExecutionsRequest.builder().applyMutation(searchFlowExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     *
     * @param searchFlowTemplatesRequest
     * @return A Java Future containing the result of the SearchFlowTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchFlowTemplatesResponse> searchFlowTemplates(
            SearchFlowTemplatesRequest searchFlowTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFlowTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFlowTemplatesRequest#builder()}
     * </p>
     *
     * @param searchFlowTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link SearchFlowTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchFlowTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchFlowTemplatesResponse> searchFlowTemplates(
            Consumer<SearchFlowTemplatesRequest.Builder> searchFlowTemplatesRequest) {
        return searchFlowTemplates(SearchFlowTemplatesRequest.builder().applyMutation(searchFlowTemplatesRequest).build());
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesPublisher publisher = client.searchFlowTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesPublisher publisher = client.searchFlowTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchFlowTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchFlowTemplatesPublisher searchFlowTemplatesPaginator(SearchFlowTemplatesRequest searchFlowTemplatesRequest) {
        return new SearchFlowTemplatesPublisher(this, searchFlowTemplatesRequest);
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesPublisher publisher = client.searchFlowTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesPublisher publisher = client.searchFlowTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFlowTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFlowTemplatesRequest#builder()}
     * </p>
     *
     * @param searchFlowTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link SearchFlowTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchFlowTemplatesPublisher searchFlowTemplatesPaginator(
            Consumer<SearchFlowTemplatesRequest.Builder> searchFlowTemplatesRequest) {
        return searchFlowTemplatesPaginator(SearchFlowTemplatesRequest.builder().applyMutation(searchFlowTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     *
     * @param searchSystemInstancesRequest
     * @return A Java Future containing the result of the SearchSystemInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchSystemInstancesResponse> searchSystemInstances(
            SearchSystemInstancesRequest searchSystemInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSystemInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSystemInstancesRequest#builder()}
     * </p>
     *
     * @param searchSystemInstancesRequest
     *        A {@link Consumer} that will call methods on {@link SearchSystemInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchSystemInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchSystemInstancesResponse> searchSystemInstances(
            Consumer<SearchSystemInstancesRequest.Builder> searchSystemInstancesRequest) {
        return searchSystemInstances(SearchSystemInstancesRequest.builder().applyMutation(searchSystemInstancesRequest).build());
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesPublisher publisher = client.searchSystemInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesPublisher publisher = client.searchSystemInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSystemInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchSystemInstancesPublisher searchSystemInstancesPaginator(
            SearchSystemInstancesRequest searchSystemInstancesRequest) {
        return new SearchSystemInstancesPublisher(this, searchSystemInstancesRequest);
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesPublisher publisher = client.searchSystemInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesPublisher publisher = client.searchSystemInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSystemInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSystemInstancesRequest#builder()}
     * </p>
     *
     * @param searchSystemInstancesRequest
     *        A {@link Consumer} that will call methods on {@link SearchSystemInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchSystemInstancesPublisher searchSystemInstancesPaginator(
            Consumer<SearchSystemInstancesRequest.Builder> searchSystemInstancesRequest) {
        return searchSystemInstancesPaginator(SearchSystemInstancesRequest.builder().applyMutation(searchSystemInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     *
     * @param searchSystemTemplatesRequest
     * @return A Java Future containing the result of the SearchSystemTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchSystemTemplatesResponse> searchSystemTemplates(
            SearchSystemTemplatesRequest searchSystemTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSystemTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSystemTemplatesRequest#builder()}
     * </p>
     *
     * @param searchSystemTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link SearchSystemTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchSystemTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchSystemTemplatesResponse> searchSystemTemplates(
            Consumer<SearchSystemTemplatesRequest.Builder> searchSystemTemplatesRequest) {
        return searchSystemTemplates(SearchSystemTemplatesRequest.builder().applyMutation(searchSystemTemplatesRequest).build());
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesPublisher publisher = client.searchSystemTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesPublisher publisher = client.searchSystemTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSystemTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchSystemTemplatesPublisher searchSystemTemplatesPaginator(
            SearchSystemTemplatesRequest searchSystemTemplatesRequest) {
        return new SearchSystemTemplatesPublisher(this, searchSystemTemplatesRequest);
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesPublisher publisher = client.searchSystemTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesPublisher publisher = client.searchSystemTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSystemTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSystemTemplatesRequest#builder()}
     * </p>
     *
     * @param searchSystemTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link SearchSystemTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchSystemTemplatesPublisher searchSystemTemplatesPaginator(
            Consumer<SearchSystemTemplatesRequest.Builder> searchSystemTemplatesRequest) {
        return searchSystemTemplatesPaginator(SearchSystemTemplatesRequest.builder().applyMutation(searchSystemTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     *
     * @param searchThingsRequest
     * @return A Java Future containing the result of the SearchThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchThingsResponse> searchThings(SearchThingsRequest searchThingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchThingsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchThingsRequest#builder()}
     * </p>
     *
     * @param searchThingsRequest
     *        A {@link Consumer} that will call methods on {@link SearchThingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<SearchThingsResponse> searchThings(Consumer<SearchThingsRequest.Builder> searchThingsRequest) {
        return searchThings(SearchThingsRequest.builder().applyMutation(searchThingsRequest).build());
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsPublisher publisher = client.searchThingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsPublisher publisher = client.searchThingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation.</b>
     * </p>
     *
     * @param searchThingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchThingsPublisher searchThingsPaginator(SearchThingsRequest searchThingsRequest) {
        return new SearchThingsPublisher(this, searchThingsRequest);
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsPublisher publisher = client.searchThingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsPublisher publisher = client.searchThingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchThingsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchThingsRequest#builder()}
     * </p>
     *
     * @param searchThingsRequest
     *        A {@link Consumer} that will call methods on {@link SearchThingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default SearchThingsPublisher searchThingsPaginator(Consumer<SearchThingsRequest.Builder> searchThingsRequest) {
        return searchThingsPaginator(SearchThingsRequest.builder().applyMutation(searchThingsRequest).build());
    }

    /**
     * <p>
     * Creates a tag for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/TagResource" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a tag for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/TagResource" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a system instance from its target (Cloud or Greengrass).
     * </p>
     *
     * @param undeploySystemInstanceRequest
     * @return A Java Future containing the result of the UndeploySystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UndeploySystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UndeploySystemInstanceResponse> undeploySystemInstance(
            UndeploySystemInstanceRequest undeploySystemInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a system instance from its target (Cloud or Greengrass).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UndeploySystemInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link UndeploySystemInstanceRequest#builder()}
     * </p>
     *
     * @param undeploySystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link UndeploySystemInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UndeploySystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UndeploySystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UndeploySystemInstanceResponse> undeploySystemInstance(
            Consumer<UndeploySystemInstanceRequest.Builder> undeploySystemInstanceRequest) {
        return undeploySystemInstance(UndeploySystemInstanceRequest.builder().applyMutation(undeploySystemInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Removes a tag from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the
     * changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new
     * workflow with a different ID), and update the copy. The workflow can contain only entities in the specified
     * namespace.
     * </p>
     *
     * @param updateFlowTemplateRequest
     * @return A Java Future containing the result of the UpdateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UpdateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UpdateFlowTemplateResponse> updateFlowTemplate(UpdateFlowTemplateRequest updateFlowTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the
     * changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new
     * workflow with a different ID), and update the copy. The workflow can contain only entities in the specified
     * namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFlowTemplateRequest#builder()}
     * </p>
     *
     * @param updateFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFlowTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UpdateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UpdateFlowTemplateResponse> updateFlowTemplate(
            Consumer<UpdateFlowTemplateRequest.Builder> updateFlowTemplateRequest) {
        return updateFlowTemplate(UpdateFlowTemplateRequest.builder().applyMutation(updateFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that
     * uses the system will see the changes in the system when it is redeployed.
     * </p>
     *
     * @param updateSystemTemplateRequest
     * @return A Java Future containing the result of the UpdateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UpdateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UpdateSystemTemplateResponse> updateSystemTemplate(
            UpdateSystemTemplateRequest updateSystemTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that
     * uses the system will see the changes in the system when it is redeployed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSystemTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSystemTemplateRequest#builder()}
     * </p>
     *
     * @param updateSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSystemTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UpdateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UpdateSystemTemplateResponse> updateSystemTemplate(
            Consumer<UpdateSystemTemplateRequest.Builder> updateSystemTemplateRequest) {
        return updateSystemTemplate(UpdateSystemTemplateRequest.builder().applyMutation(updateSystemTemplateRequest).build());
    }

    /**
     * <p>
     * Asynchronously uploads one or more entity definitions to the user's namespace. The <code>document</code>
     * parameter is required if <code>syncWithPublicNamespace</code> and <code>deleteExistingEntites</code> are false.
     * If the <code>syncWithPublicNamespace</code> parameter is set to <code>true</code>, the user's namespace will
     * synchronize with the latest version of the public namespace. If <code>deprecateExistingEntities</code> is set to
     * true, all entities in the latest version will be deleted before the new <code>DefinitionDocument</code> is
     * uploaded.
     * </p>
     * <p>
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The
     * new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version
     * increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets
     * the <code>syncWithPublicNamespace</code> parameter or the <code>deprecateExistingEntities</code> parameter to
     * <code>true</code>.
     * </p>
     * <p>
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't
     * create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     * </p>
     * <p>
     * Valid entities are <code>Device</code>, <code>DeviceModel</code>, <code>Service</code>, <code>Capability</code>,
     * <code>State</code>, <code>Action</code>, <code>Event</code>, <code>Property</code>, <code>Mapping</code>,
     * <code>Enum</code>.
     * </p>
     *
     * @param uploadEntityDefinitionsRequest
     * @return A Java Future containing the result of the UploadEntityDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UploadEntityDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UploadEntityDefinitions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UploadEntityDefinitionsResponse> uploadEntityDefinitions(
            UploadEntityDefinitionsRequest uploadEntityDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Asynchronously uploads one or more entity definitions to the user's namespace. The <code>document</code>
     * parameter is required if <code>syncWithPublicNamespace</code> and <code>deleteExistingEntites</code> are false.
     * If the <code>syncWithPublicNamespace</code> parameter is set to <code>true</code>, the user's namespace will
     * synchronize with the latest version of the public namespace. If <code>deprecateExistingEntities</code> is set to
     * true, all entities in the latest version will be deleted before the new <code>DefinitionDocument</code> is
     * uploaded.
     * </p>
     * <p>
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The
     * new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version
     * increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets
     * the <code>syncWithPublicNamespace</code> parameter or the <code>deprecateExistingEntities</code> parameter to
     * <code>true</code>.
     * </p>
     * <p>
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't
     * create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     * </p>
     * <p>
     * Valid entities are <code>Device</code>, <code>DeviceModel</code>, <code>Service</code>, <code>Capability</code>,
     * <code>State</code>, <code>Action</code>, <code>Event</code>, <code>Property</code>, <code>Mapping</code>,
     * <code>Enum</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadEntityDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link UploadEntityDefinitionsRequest#builder()}
     * </p>
     *
     * @param uploadEntityDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link UploadEntityDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UploadEntityDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UploadEntityDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UploadEntityDefinitions"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated since: 2022-08-30
     */
    @Deprecated
    default CompletableFuture<UploadEntityDefinitionsResponse> uploadEntityDefinitions(
            Consumer<UploadEntityDefinitionsRequest.Builder> uploadEntityDefinitionsRequest) {
        return uploadEntityDefinitions(UploadEntityDefinitionsRequest.builder().applyMutation(uploadEntityDefinitionsRequest)
                .build());
    }

    @Override
    default IoTThingsGraphServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IoTThingsGraphAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTThingsGraphAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTThingsGraphAsyncClient}.
     */
    static IoTThingsGraphAsyncClientBuilder builder() {
        return new DefaultIoTThingsGraphAsyncClientBuilder();
    }
}
