/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary;

public class GetSystemTemplateRevisionsIterable
implements SdkIterable<GetSystemTemplateRevisionsResponse> {
    private final IoTThingsGraphClient client;
    private final GetSystemTemplateRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSystemTemplateRevisionsIterable(IoTThingsGraphClient client, GetSystemTemplateRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSystemTemplateRevisionsResponseFetcher();
    }

    public Iterator<GetSystemTemplateRevisionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SystemTemplateSummary> summaries() {
        Function<GetSystemTemplateRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSystemTemplateRevisionsResponseFetcher
    implements SyncPageFetcher<GetSystemTemplateRevisionsResponse> {
        private GetSystemTemplateRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(GetSystemTemplateRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSystemTemplateRevisionsResponse nextPage(GetSystemTemplateRevisionsResponse previousPage) {
            if (previousPage == null) {
                return GetSystemTemplateRevisionsIterable.this.client.getSystemTemplateRevisions(GetSystemTemplateRevisionsIterable.this.firstRequest);
            }
            return GetSystemTemplateRevisionsIterable.this.client.getSystemTemplateRevisions((GetSystemTemplateRevisionsRequest)((Object)GetSystemTemplateRevisionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

