/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.StringListCopier;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUploadStatusResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, GetUploadStatusResponse> {
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(GetUploadStatusResponse.getter(GetUploadStatusResponse::uploadId)).setter(GetUploadStatusResponse.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final SdkField<String> UPLOAD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadStatus").getter(GetUploadStatusResponse.getter(GetUploadStatusResponse::uploadStatusAsString)).setter(GetUploadStatusResponse.setter(Builder::uploadStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadStatus").build()}).build();
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceArn").getter(GetUploadStatusResponse.getter(GetUploadStatusResponse::namespaceArn)).setter(GetUploadStatusResponse.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(GetUploadStatusResponse.getter(GetUploadStatusResponse::namespaceName)).setter(GetUploadStatusResponse.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("namespaceVersion").getter(GetUploadStatusResponse.getter(GetUploadStatusResponse::namespaceVersion)).setter(GetUploadStatusResponse.setter(Builder::namespaceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReason").getter(GetUploadStatusResponse.getter(GetUploadStatusResponse::failureReason)).setter(GetUploadStatusResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(GetUploadStatusResponse.getter(GetUploadStatusResponse::createdDate)).setter(GetUploadStatusResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_ID_FIELD, UPLOAD_STATUS_FIELD, NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD, NAMESPACE_VERSION_FIELD, FAILURE_REASON_FIELD, CREATED_DATE_FIELD));
    private final String uploadId;
    private final String uploadStatus;
    private final String namespaceArn;
    private final String namespaceName;
    private final Long namespaceVersion;
    private final List<String> failureReason;
    private final Instant createdDate;

    private GetUploadStatusResponse(BuilderImpl builder) {
        super(builder);
        this.uploadId = builder.uploadId;
        this.uploadStatus = builder.uploadStatus;
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.namespaceVersion = builder.namespaceVersion;
        this.failureReason = builder.failureReason;
        this.createdDate = builder.createdDate;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final UploadStatus uploadStatus() {
        return UploadStatus.fromValue(this.uploadStatus);
    }

    public final String uploadStatusAsString() {
        return this.uploadStatus;
    }

    public final String namespaceArn() {
        return this.namespaceArn;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final Long namespaceVersion() {
        return this.namespaceVersion;
    }

    public final boolean hasFailureReason() {
        return this.failureReason != null && !(this.failureReason instanceof SdkAutoConstructList);
    }

    public final List<String> failureReason() {
        return this.failureReason;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReason() ? this.failureReason() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUploadStatusResponse)) {
            return false;
        }
        GetUploadStatusResponse other = (GetUploadStatusResponse)((Object)obj);
        return Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.uploadStatusAsString(), other.uploadStatusAsString()) && Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.namespaceVersion(), other.namespaceVersion()) && this.hasFailureReason() == other.hasFailureReason() && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.createdDate(), other.createdDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetUploadStatusResponse").add("UploadId", (Object)this.uploadId()).add("UploadStatus", (Object)this.uploadStatusAsString()).add("NamespaceArn", (Object)this.namespaceArn()).add("NamespaceName", (Object)this.namespaceName()).add("NamespaceVersion", (Object)this.namespaceVersion()).add("FailureReason", this.hasFailureReason() ? this.failureReason() : null).add("CreatedDate", (Object)this.createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "uploadStatus": {
                return Optional.ofNullable(clazz.cast(this.uploadStatusAsString()));
            }
            case "namespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "namespaceVersion": {
                return Optional.ofNullable(clazz.cast(this.namespaceVersion()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUploadStatusResponse, T> g) {
        return obj -> g.apply((GetUploadStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private String uploadId;
        private String uploadStatus;
        private String namespaceArn;
        private String namespaceName;
        private Long namespaceVersion;
        private List<String> failureReason = DefaultSdkAutoConstructList.getInstance();
        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUploadStatusResponse model) {
            super(model);
            this.uploadId(model.uploadId);
            this.uploadStatus(model.uploadStatus);
            this.namespaceArn(model.namespaceArn);
            this.namespaceName(model.namespaceName);
            this.namespaceVersion(model.namespaceVersion);
            this.failureReason(model.failureReason);
            this.createdDate(model.createdDate);
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getUploadStatus() {
            return this.uploadStatus;
        }

        public final void setUploadStatus(String uploadStatus) {
            this.uploadStatus = uploadStatus;
        }

        @Override
        public final Builder uploadStatus(String uploadStatus) {
            this.uploadStatus = uploadStatus;
            return this;
        }

        @Override
        public final Builder uploadStatus(UploadStatus uploadStatus) {
            this.uploadStatus(uploadStatus == null ? null : uploadStatus.toString());
            return this;
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Long getNamespaceVersion() {
            return this.namespaceVersion;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        public final Collection<String> getFailureReason() {
            if (this.failureReason instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReason;
        }

        public final void setFailureReason(Collection<String> failureReason) {
            this.failureReason = StringListCopier.copy(failureReason);
        }

        @Override
        public final Builder failureReason(Collection<String> failureReason) {
            this.failureReason = StringListCopier.copy(failureReason);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReason(String ... failureReason) {
            this.failureReason(Arrays.asList(failureReason));
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Override
        public GetUploadStatusResponse build() {
            return new GetUploadStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUploadStatusResponse> {
        public Builder uploadId(String var1);

        public Builder uploadStatus(String var1);

        public Builder uploadStatus(UploadStatus var1);

        public Builder namespaceArn(String var1);

        public Builder namespaceName(String var1);

        public Builder namespaceVersion(Long var1);

        public Builder failureReason(Collection<String> var1);

        public Builder failureReason(String ... var1);

        public Builder createdDate(Instant var1);
    }
}

