/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SystemInstanceFilterName {
    SYSTEM_TEMPLATE_ID("SYSTEM_TEMPLATE_ID"),
    STATUS("STATUS"),
    GREENGRASS_GROUP_NAME("GREENGRASS_GROUP_NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SystemInstanceFilterName> VALUE_MAP;
    private final String value;

    private SystemInstanceFilterName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SystemInstanceFilterName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SystemInstanceFilterName> knownValues() {
        EnumSet<SystemInstanceFilterName> knownValues = EnumSet.allOf(SystemInstanceFilterName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SystemInstanceFilterName.class, SystemInstanceFilterName::toString);
    }
}

