/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UrnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEntitiesRequest
extends IoTThingsGraphRequest
implements ToCopyableBuilder<Builder, GetEntitiesRequest> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ids").getter(GetEntitiesRequest.getter(GetEntitiesRequest::ids)).setter(GetEntitiesRequest.setter(Builder::ids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("namespaceVersion").getter(GetEntitiesRequest.getter(GetEntitiesRequest::namespaceVersion)).setter(GetEntitiesRequest.setter(Builder::namespaceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD, NAMESPACE_VERSION_FIELD));
    private final List<String> ids;
    private final Long namespaceVersion;

    private GetEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.namespaceVersion = builder.namespaceVersion;
    }

    public final boolean hasIds() {
        return this.ids != null && !(this.ids instanceof SdkAutoConstructList);
    }

    public final List<String> ids() {
        return this.ids;
    }

    public final Long namespaceVersion() {
        return this.namespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIds() ? this.ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntitiesRequest)) {
            return false;
        }
        GetEntitiesRequest other = (GetEntitiesRequest)((Object)obj);
        return this.hasIds() == other.hasIds() && Objects.equals(this.ids(), other.ids()) && Objects.equals(this.namespaceVersion(), other.namespaceVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetEntitiesRequest").add("Ids", this.hasIds() ? this.ids() : null).add("NamespaceVersion", (Object)this.namespaceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ids": {
                return Optional.ofNullable(clazz.cast(this.ids()));
            }
            case "namespaceVersion": {
                return Optional.ofNullable(clazz.cast(this.namespaceVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntitiesRequest, T> g) {
        return obj -> g.apply((GetEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphRequest.BuilderImpl
    implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();
        private Long namespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntitiesRequest model) {
            super(model);
            this.ids(model.ids);
            this.namespaceVersion(model.namespaceVersion);
        }

        public final Collection<String> getIds() {
            if (this.ids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = UrnsCopier.copy(ids);
        }

        @Override
        @Transient
        public final Builder ids(Collection<String> ids) {
            this.ids = UrnsCopier.copy(ids);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final Long getNamespaceVersion() {
            return this.namespaceVersion;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        @Transient
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEntitiesRequest build() {
            return new GetEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEntitiesRequest> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder namespaceVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

