/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.Thing;
import software.amazon.awssdk.services.iotthingsgraph.model.ThingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchThingsResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, SearchThingsResponse> {
    private static final SdkField<List<Thing>> THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("things").getter(SearchThingsResponse.getter(SearchThingsResponse::things)).setter(SearchThingsResponse.setter(Builder::things)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("things").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Thing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchThingsResponse.getter(SearchThingsResponse::nextToken)).setter(SearchThingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Thing> things;
    private final String nextToken;

    private SearchThingsResponse(BuilderImpl builder) {
        super(builder);
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasThings() {
        return this.things != null && !(this.things instanceof SdkAutoConstructList);
    }

    public final List<Thing> things() {
        return this.things;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThings() ? this.things() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchThingsResponse)) {
            return false;
        }
        SearchThingsResponse other = (SearchThingsResponse)((Object)obj);
        return this.hasThings() == other.hasThings() && Objects.equals(this.things(), other.things()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchThingsResponse").add("Things", this.hasThings() ? this.things() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "things": {
                return Optional.ofNullable(clazz.cast(this.things()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchThingsResponse, T> g) {
        return obj -> g.apply((SearchThingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private List<Thing> things = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchThingsResponse model) {
            super(model);
            this.things(model.things);
            this.nextToken(model.nextToken);
        }

        public final List<Thing.Builder> getThings() {
            List<Thing.Builder> result = ThingsCopier.copyToBuilder(this.things);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThings(Collection<Thing.BuilderImpl> things) {
            this.things = ThingsCopier.copyFromBuilder(things);
        }

        @Override
        @Transient
        public final Builder things(Collection<Thing> things) {
            this.things = ThingsCopier.copy(things);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder things(Thing ... things) {
            this.things(Arrays.asList(things));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder things(Consumer<Thing.Builder> ... things) {
            this.things(Stream.of(things).map(c -> (Thing)((Thing.Builder)Thing.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchThingsResponse build() {
            return new SearchThingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchThingsResponse> {
        public Builder things(Collection<Thing> var1);

        public Builder things(Thing ... var1);

        public Builder things(Consumer<Thing.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

