/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.DefinitionDocument;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSystemTemplateRequest
extends IoTThingsGraphRequest
implements ToCopyableBuilder<Builder, CreateSystemTemplateRequest> {
    private static final SdkField<DefinitionDocument> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(CreateSystemTemplateRequest.getter(CreateSystemTemplateRequest::definition)).setter(CreateSystemTemplateRequest.setter(Builder::definition)).constructor(DefinitionDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<Long> COMPATIBLE_NAMESPACE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("compatibleNamespaceVersion").getter(CreateSystemTemplateRequest.getter(CreateSystemTemplateRequest::compatibleNamespaceVersion)).setter(CreateSystemTemplateRequest.setter(Builder::compatibleNamespaceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleNamespaceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, COMPATIBLE_NAMESPACE_VERSION_FIELD));
    private final DefinitionDocument definition;
    private final Long compatibleNamespaceVersion;

    private CreateSystemTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.compatibleNamespaceVersion = builder.compatibleNamespaceVersion;
    }

    public final DefinitionDocument definition() {
        return this.definition;
    }

    public final Long compatibleNamespaceVersion() {
        return this.compatibleNamespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibleNamespaceVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSystemTemplateRequest)) {
            return false;
        }
        CreateSystemTemplateRequest other = (CreateSystemTemplateRequest)((Object)obj);
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.compatibleNamespaceVersion(), other.compatibleNamespaceVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSystemTemplateRequest").add("Definition", (Object)this.definition()).add("CompatibleNamespaceVersion", (Object)this.compatibleNamespaceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "compatibleNamespaceVersion": {
                return Optional.ofNullable(clazz.cast(this.compatibleNamespaceVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSystemTemplateRequest, T> g) {
        return obj -> g.apply((CreateSystemTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphRequest.BuilderImpl
    implements Builder {
        private DefinitionDocument definition;
        private Long compatibleNamespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSystemTemplateRequest model) {
            super(model);
            this.definition(model.definition);
            this.compatibleNamespaceVersion(model.compatibleNamespaceVersion);
        }

        public final DefinitionDocument.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DefinitionDocument definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DefinitionDocument.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final Long getCompatibleNamespaceVersion() {
            return this.compatibleNamespaceVersion;
        }

        @Override
        public final Builder compatibleNamespaceVersion(Long compatibleNamespaceVersion) {
            this.compatibleNamespaceVersion = compatibleNamespaceVersion;
            return this;
        }

        public final void setCompatibleNamespaceVersion(Long compatibleNamespaceVersion) {
            this.compatibleNamespaceVersion = compatibleNamespaceVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSystemTemplateRequest build() {
            return new CreateSystemTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSystemTemplateRequest> {
        public Builder definition(DefinitionDocument var1);

        default public Builder definition(Consumer<DefinitionDocument.Builder> definition) {
            return this.definition((DefinitionDocument)((DefinitionDocument.Builder)DefinitionDocument.builder().applyMutation(definition)).build());
        }

        public Builder compatibleNamespaceVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

