/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowExecutionSummary> {
    private static final SdkField<String> FLOW_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowExecutionId").getter(FlowExecutionSummary.getter(FlowExecutionSummary::flowExecutionId)).setter(FlowExecutionSummary.setter(Builder::flowExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(FlowExecutionSummary.getter(FlowExecutionSummary::statusAsString)).setter(FlowExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SYSTEM_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemInstanceId").getter(FlowExecutionSummary.getter(FlowExecutionSummary::systemInstanceId)).setter(FlowExecutionSummary.setter(Builder::systemInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInstanceId").build()}).build();
    private static final SdkField<String> FLOW_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowTemplateId").getter(FlowExecutionSummary.getter(FlowExecutionSummary::flowTemplateId)).setter(FlowExecutionSummary.setter(Builder::flowTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowTemplateId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(FlowExecutionSummary.getter(FlowExecutionSummary::createdAt)).setter(FlowExecutionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(FlowExecutionSummary.getter(FlowExecutionSummary::updatedAt)).setter(FlowExecutionSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_EXECUTION_ID_FIELD, STATUS_FIELD, SYSTEM_INSTANCE_ID_FIELD, FLOW_TEMPLATE_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String flowExecutionId;
    private final String status;
    private final String systemInstanceId;
    private final String flowTemplateId;
    private final Instant createdAt;
    private final Instant updatedAt;

    private FlowExecutionSummary(BuilderImpl builder) {
        this.flowExecutionId = builder.flowExecutionId;
        this.status = builder.status;
        this.systemInstanceId = builder.systemInstanceId;
        this.flowTemplateId = builder.flowTemplateId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String flowExecutionId() {
        return this.flowExecutionId;
    }

    public final FlowExecutionStatus status() {
        return FlowExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String systemInstanceId() {
        return this.systemInstanceId;
    }

    public final String flowTemplateId() {
        return this.flowTemplateId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionSummary)) {
            return false;
        }
        FlowExecutionSummary other = (FlowExecutionSummary)obj;
        return Objects.equals(this.flowExecutionId(), other.flowExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.systemInstanceId(), other.systemInstanceId()) && Objects.equals(this.flowTemplateId(), other.flowTemplateId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"FlowExecutionSummary").add("FlowExecutionId", (Object)this.flowExecutionId()).add("Status", (Object)this.statusAsString()).add("SystemInstanceId", (Object)this.systemInstanceId()).add("FlowTemplateId", (Object)this.flowTemplateId()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowExecutionId": {
                return Optional.ofNullable(clazz.cast(this.flowExecutionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "systemInstanceId": {
                return Optional.ofNullable(clazz.cast(this.systemInstanceId()));
            }
            case "flowTemplateId": {
                return Optional.ofNullable(clazz.cast(this.flowTemplateId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionSummary, T> g) {
        return obj -> g.apply((FlowExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowExecutionId;
        private String status;
        private String systemInstanceId;
        private String flowTemplateId;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionSummary model) {
            this.flowExecutionId(model.flowExecutionId);
            this.status(model.status);
            this.systemInstanceId(model.systemInstanceId);
            this.flowTemplateId(model.flowTemplateId);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getFlowExecutionId() {
            return this.flowExecutionId;
        }

        @Override
        public final Builder flowExecutionId(String flowExecutionId) {
            this.flowExecutionId = flowExecutionId;
            return this;
        }

        public final void setFlowExecutionId(String flowExecutionId) {
            this.flowExecutionId = flowExecutionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSystemInstanceId() {
            return this.systemInstanceId;
        }

        @Override
        public final Builder systemInstanceId(String systemInstanceId) {
            this.systemInstanceId = systemInstanceId;
            return this;
        }

        public final void setSystemInstanceId(String systemInstanceId) {
            this.systemInstanceId = systemInstanceId;
        }

        public final String getFlowTemplateId() {
            return this.flowTemplateId;
        }

        @Override
        public final Builder flowTemplateId(String flowTemplateId) {
            this.flowTemplateId = flowTemplateId;
            return this;
        }

        public final void setFlowTemplateId(String flowTemplateId) {
            this.flowTemplateId = flowTemplateId;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public FlowExecutionSummary build() {
            return new FlowExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowExecutionSummary> {
        public Builder flowExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(FlowExecutionStatus var1);

        public Builder systemInstanceId(String var1);

        public Builder flowTemplateId(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

