/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.NamespaceDeletionStatus;
import software.amazon.awssdk.services.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNamespaceDeletionStatusResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, GetNamespaceDeletionStatusResponse> {
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceArn").getter(GetNamespaceDeletionStatusResponse.getter(GetNamespaceDeletionStatusResponse::namespaceArn)).setter(GetNamespaceDeletionStatusResponse.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(GetNamespaceDeletionStatusResponse.getter(GetNamespaceDeletionStatusResponse::namespaceName)).setter(GetNamespaceDeletionStatusResponse.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetNamespaceDeletionStatusResponse.getter(GetNamespaceDeletionStatusResponse::statusAsString)).setter(GetNamespaceDeletionStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(GetNamespaceDeletionStatusResponse.getter(GetNamespaceDeletionStatusResponse::errorCodeAsString)).setter(GetNamespaceDeletionStatusResponse.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(GetNamespaceDeletionStatusResponse.getter(GetNamespaceDeletionStatusResponse::errorMessage)).setter(GetNamespaceDeletionStatusResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD, STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private final String namespaceArn;
    private final String namespaceName;
    private final String status;
    private final String errorCode;
    private final String errorMessage;

    private GetNamespaceDeletionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public String namespaceArn() {
        return this.namespaceArn;
    }

    public String namespaceName() {
        return this.namespaceName;
    }

    public NamespaceDeletionStatus status() {
        return NamespaceDeletionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public NamespaceDeletionStatusErrorCodes errorCode() {
        return NamespaceDeletionStatusErrorCodes.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamespaceDeletionStatusResponse)) {
            return false;
        }
        GetNamespaceDeletionStatusResponse other = (GetNamespaceDeletionStatusResponse)((Object)obj);
        return Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        return ToString.builder((String)"GetNamespaceDeletionStatusResponse").add("NamespaceArn", (Object)this.namespaceArn()).add("NamespaceName", (Object)this.namespaceName()).add("Status", (Object)this.statusAsString()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNamespaceDeletionStatusResponse, T> g) {
        return obj -> g.apply((GetNamespaceDeletionStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private String namespaceArn;
        private String namespaceName;
        private String status;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamespaceDeletionStatusResponse model) {
            super(model);
            this.namespaceArn(model.namespaceArn);
            this.namespaceName(model.namespaceName);
            this.status(model.status);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NamespaceDeletionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(NamespaceDeletionStatusErrorCodes errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public GetNamespaceDeletionStatusResponse build() {
            return new GetNamespaceDeletionStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNamespaceDeletionStatusResponse> {
        public Builder namespaceArn(String var1);

        public Builder namespaceName(String var1);

        public Builder status(String var1);

        public Builder status(NamespaceDeletionStatus var1);

        public Builder errorCode(String var1);

        public Builder errorCode(NamespaceDeletionStatusErrorCodes var1);

        public Builder errorMessage(String var1);
    }
}

