/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionMessage;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse;

public class ListFlowExecutionMessagesIterable
implements SdkIterable<ListFlowExecutionMessagesResponse> {
    private final IoTThingsGraphClient client;
    private final ListFlowExecutionMessagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowExecutionMessagesIterable(IoTThingsGraphClient client, ListFlowExecutionMessagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFlowExecutionMessagesResponseFetcher();
    }

    public Iterator<ListFlowExecutionMessagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowExecutionMessage> messages() {
        Function<ListFlowExecutionMessagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.messages() != null) {
                return response.messages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowExecutionMessagesResponseFetcher
    implements SyncPageFetcher<ListFlowExecutionMessagesResponse> {
        private ListFlowExecutionMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowExecutionMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowExecutionMessagesResponse nextPage(ListFlowExecutionMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListFlowExecutionMessagesIterable.this.client.listFlowExecutionMessages(ListFlowExecutionMessagesIterable.this.firstRequest);
            }
            return ListFlowExecutionMessagesIterable.this.client.listFlowExecutionMessages((ListFlowExecutionMessagesRequest)((Object)ListFlowExecutionMessagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

