/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNamespaceDeletionStatusResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<GetNamespaceDeletionStatusResponse.Builder, GetNamespaceDeletionStatusResponse> {
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetNamespaceDeletionStatusResponse::namespaceArn)).setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetNamespaceDeletionStatusResponse::namespaceName)).setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetNamespaceDeletionStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetNamespaceDeletionStatusResponse::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetNamespaceDeletionStatusResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_ARN_FIELD,
            NAMESPACE_NAME_FIELD, STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private final String namespaceArn;

    private final String namespaceName;

    private final String status;

    private final String errorCode;

    private final String errorMessage;

    private GetNamespaceDeletionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The ARN of the namespace that is being deleted.
     * </p>
     * 
     * @return The ARN of the namespace that is being deleted.
     */
    public String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The name of the namespace that is being deleted.
     * </p>
     * 
     * @return The name of the namespace that is being deleted.
     */
    public String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The status of the deletion request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NamespaceDeletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deletion request.
     * @see NamespaceDeletionStatus
     */
    public NamespaceDeletionStatus status() {
        return NamespaceDeletionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the deletion request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NamespaceDeletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deletion request.
     * @see NamespaceDeletionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An error code returned by the namespace deletion task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link NamespaceDeletionStatusErrorCodes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return An error code returned by the namespace deletion task.
     * @see NamespaceDeletionStatusErrorCodes
     */
    public NamespaceDeletionStatusErrorCodes errorCode() {
        return NamespaceDeletionStatusErrorCodes.fromValue(errorCode);
    }

    /**
     * <p>
     * An error code returned by the namespace deletion task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link NamespaceDeletionStatusErrorCodes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return An error code returned by the namespace deletion task.
     * @see NamespaceDeletionStatusErrorCodes
     */
    public String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * An error code returned by the namespace deletion task.
     * </p>
     * 
     * @return An error code returned by the namespace deletion task.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamespaceDeletionStatusResponse)) {
            return false;
        }
        GetNamespaceDeletionStatusResponse other = (GetNamespaceDeletionStatusResponse) obj;
        return Objects.equals(namespaceArn(), other.namespaceArn()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetNamespaceDeletionStatusResponse").add("NamespaceArn", namespaceArn())
                .add("NamespaceName", namespaceName()).add("Status", statusAsString()).add("ErrorCode", errorCodeAsString())
                .add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNamespaceDeletionStatusResponse, T> g) {
        return obj -> g.apply((GetNamespaceDeletionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNamespaceDeletionStatusResponse> {
        /**
         * <p>
         * The ARN of the namespace that is being deleted.
         * </p>
         * 
         * @param namespaceArn
         *        The ARN of the namespace that is being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The name of the namespace that is being deleted.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace that is being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The status of the deletion request.
         * </p>
         * 
         * @param status
         *        The status of the deletion request.
         * @see NamespaceDeletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceDeletionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deletion request.
         * </p>
         * 
         * @param status
         *        The status of the deletion request.
         * @see NamespaceDeletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceDeletionStatus
         */
        Builder status(NamespaceDeletionStatus status);

        /**
         * <p>
         * An error code returned by the namespace deletion task.
         * </p>
         * 
         * @param errorCode
         *        An error code returned by the namespace deletion task.
         * @see NamespaceDeletionStatusErrorCodes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceDeletionStatusErrorCodes
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error code returned by the namespace deletion task.
         * </p>
         * 
         * @param errorCode
         *        An error code returned by the namespace deletion task.
         * @see NamespaceDeletionStatusErrorCodes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceDeletionStatusErrorCodes
         */
        Builder errorCode(NamespaceDeletionStatusErrorCodes errorCode);

        /**
         * <p>
         * An error code returned by the namespace deletion task.
         * </p>
         * 
         * @param errorMessage
         *        An error code returned by the namespace deletion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private String namespaceArn;

        private String namespaceName;

        private String status;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamespaceDeletionStatusResponse model) {
            super(model);
            namespaceArn(model.namespaceArn);
            namespaceName(model.namespaceName);
            status(model.status);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NamespaceDeletionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorCodeAsString() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(NamespaceDeletionStatusErrorCodes errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public GetNamespaceDeletionStatusResponse build() {
            return new GetNamespaceDeletionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
