/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a workflow's definition and summary information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTemplateDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTemplateDescription.Builder, FlowTemplateDescription> {
    private static final SdkField<FlowTemplateSummary> SUMMARY_FIELD = SdkField
            .<FlowTemplateSummary> builder(MarshallingType.SDK_POJO).getter(getter(FlowTemplateDescription::summary))
            .setter(setter(Builder::summary)).constructor(FlowTemplateSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<DefinitionDocument> DEFINITION_FIELD = SdkField
            .<DefinitionDocument> builder(MarshallingType.SDK_POJO).getter(getter(FlowTemplateDescription::definition))
            .setter(setter(Builder::definition)).constructor(DefinitionDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<Long> VALIDATED_NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(FlowTemplateDescription::validatedNamespaceVersion))
            .setter(setter(Builder::validatedNamespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validatedNamespaceVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD,
            DEFINITION_FIELD, VALIDATED_NAMESPACE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final FlowTemplateSummary summary;

    private final DefinitionDocument definition;

    private final Long validatedNamespaceVersion;

    private FlowTemplateDescription(BuilderImpl builder) {
        this.summary = builder.summary;
        this.definition = builder.definition;
        this.validatedNamespaceVersion = builder.validatedNamespaceVersion;
    }

    /**
     * <p>
     * An object that contains summary information about a workflow.
     * </p>
     * 
     * @return An object that contains summary information about a workflow.
     */
    public FlowTemplateSummary summary() {
        return summary;
    }

    /**
     * <p>
     * A workflow's definition document.
     * </p>
     * 
     * @return A workflow's definition document.
     */
    public DefinitionDocument definition() {
        return definition;
    }

    /**
     * <p>
     * The version of the user's namespace against which the workflow was validated. Use this value in your system
     * instance.
     * </p>
     * 
     * @return The version of the user's namespace against which the workflow was validated. Use this value in your
     *         system instance.
     */
    public Long validatedNamespaceVersion() {
        return validatedNamespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(validatedNamespaceVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTemplateDescription)) {
            return false;
        }
        FlowTemplateDescription other = (FlowTemplateDescription) obj;
        return Objects.equals(summary(), other.summary()) && Objects.equals(definition(), other.definition())
                && Objects.equals(validatedNamespaceVersion(), other.validatedNamespaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FlowTemplateDescription").add("Summary", summary()).add("Definition", definition())
                .add("ValidatedNamespaceVersion", validatedNamespaceVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "validatedNamespaceVersion":
            return Optional.ofNullable(clazz.cast(validatedNamespaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowTemplateDescription, T> g) {
        return obj -> g.apply((FlowTemplateDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTemplateDescription> {
        /**
         * <p>
         * An object that contains summary information about a workflow.
         * </p>
         * 
         * @param summary
         *        An object that contains summary information about a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(FlowTemplateSummary summary);

        /**
         * <p>
         * An object that contains summary information about a workflow.
         * </p>
         * This is a convenience that creates an instance of the {@link FlowTemplateSummary.Builder} avoiding the need
         * to create one manually via {@link FlowTemplateSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link FlowTemplateSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #summary(FlowTemplateSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link FlowTemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(FlowTemplateSummary)
         */
        default Builder summary(Consumer<FlowTemplateSummary.Builder> summary) {
            return summary(FlowTemplateSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * A workflow's definition document.
         * </p>
         * 
         * @param definition
         *        A workflow's definition document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(DefinitionDocument definition);

        /**
         * <p>
         * A workflow's definition document.
         * </p>
         * This is a convenience that creates an instance of the {@link DefinitionDocument.Builder} avoiding the need to
         * create one manually via {@link DefinitionDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefinitionDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(DefinitionDocument)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link DefinitionDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(DefinitionDocument)
         */
        default Builder definition(Consumer<DefinitionDocument.Builder> definition) {
            return definition(DefinitionDocument.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The version of the user's namespace against which the workflow was validated. Use this value in your system
         * instance.
         * </p>
         * 
         * @param validatedNamespaceVersion
         *        The version of the user's namespace against which the workflow was validated. Use this value in your
         *        system instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validatedNamespaceVersion(Long validatedNamespaceVersion);
    }

    static final class BuilderImpl implements Builder {
        private FlowTemplateSummary summary;

        private DefinitionDocument definition;

        private Long validatedNamespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTemplateDescription model) {
            summary(model.summary);
            definition(model.definition);
            validatedNamespaceVersion(model.validatedNamespaceVersion);
        }

        public final FlowTemplateSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(FlowTemplateSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(FlowTemplateSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        public final DefinitionDocument.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DefinitionDocument definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DefinitionDocument.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final Long getValidatedNamespaceVersion() {
            return validatedNamespaceVersion;
        }

        @Override
        public final Builder validatedNamespaceVersion(Long validatedNamespaceVersion) {
            this.validatedNamespaceVersion = validatedNamespaceVersion;
            return this;
        }

        public final void setValidatedNamespaceVersion(Long validatedNamespaceVersion) {
            this.validatedNamespaceVersion = validatedNamespaceVersion;
        }

        @Override
        public FlowTemplateDescription build() {
            return new FlowTemplateDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
