/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorEventOperation {
    DEVICE_COMMAND_RESPONSE("DEVICE_COMMAND_RESPONSE"),
    DEVICE_DISCOVERY("DEVICE_DISCOVERY"),
    DEVICE_EVENT("DEVICE_EVENT"),
    DEVICE_COMMAND_REQUEST("DEVICE_COMMAND_REQUEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorEventOperation> VALUE_MAP;
    private final String value;

    private ConnectorEventOperation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorEventOperation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorEventOperation> knownValues() {
        EnumSet<ConnectorEventOperation> knownValues = EnumSet.allOf(ConnectorEventOperation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorEventOperation.class, ConnectorEventOperation::toString);
    }
}

