/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssociationState {
    ASSOCIATION_IN_PROGRESS("ASSOCIATION_IN_PROGRESS"),
    ASSOCIATION_FAILED("ASSOCIATION_FAILED"),
    ASSOCIATION_SUCCEEDED("ASSOCIATION_SUCCEEDED"),
    ASSOCIATION_DELETING("ASSOCIATION_DELETING"),
    REFRESH_TOKEN_EXPIRED("REFRESH_TOKEN_EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssociationState> VALUE_MAP;
    private final String value;

    private AssociationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssociationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssociationState> knownValues() {
        EnumSet<AssociationState> knownValues = EnumSet.allOf(AssociationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssociationState.class, AssociationState::toString);
    }
}

