/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ManagedThingSummary;

public class ListManagedThingsIterable
implements SdkIterable<ListManagedThingsResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListManagedThingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedThingsIterable(IotManagedIntegrationsClient client, ListManagedThingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedThingsResponseFetcher();
    }

    public Iterator<ListManagedThingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedThingSummary> items() {
        Function<ListManagedThingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedThingsResponseFetcher
    implements SyncPageFetcher<ListManagedThingsResponse> {
        private ListManagedThingsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedThingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedThingsResponse nextPage(ListManagedThingsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedThingsIterable.this.client.listManagedThings(ListManagedThingsIterable.this.firstRequest);
            }
            return ListManagedThingsIterable.this.client.listManagedThings((ListManagedThingsRequest)((Object)ListManagedThingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

