/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConnectorEventOperation;
import software.amazon.awssdk.services.iotmanagedintegrations.model.Device;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DevicesCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterEndpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendConnectorEventRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, SendConnectorEventRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::connectorId)).setter(SendConnectorEventRequest.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::userId)).setter(SendConnectorEventRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::operationAsString)).setter(SendConnectorEventRequest.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<String> OPERATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationVersion").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::operationVersion)).setter(SendConnectorEventRequest.setter(Builder::operationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationVersion").build()}).build();
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusCode").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::statusCode)).setter(SendConnectorEventRequest.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::message)).setter(SendConnectorEventRequest.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> DEVICE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceDiscoveryId").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::deviceDiscoveryId)).setter(SendConnectorEventRequest.setter(Builder::deviceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDiscoveryId").build()}).build();
    private static final SdkField<String> CONNECTOR_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDeviceId").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::connectorDeviceId)).setter(SendConnectorEventRequest.setter(Builder::connectorDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceId").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TraceId").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::traceId)).setter(SendConnectorEventRequest.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceId").build()}).build();
    private static final SdkField<List<Device>> DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Devices").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::devices)).setter(SendConnectorEventRequest.setter(Builder::devices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Devices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MatterEndpoint> MATTER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MatterEndpoint").getter(SendConnectorEventRequest.getter(SendConnectorEventRequest::matterEndpoint)).setter(SendConnectorEventRequest.setter(Builder::matterEndpoint)).constructor(MatterEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatterEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, USER_ID_FIELD, OPERATION_FIELD, OPERATION_VERSION_FIELD, STATUS_CODE_FIELD, MESSAGE_FIELD, DEVICE_DISCOVERY_ID_FIELD, CONNECTOR_DEVICE_ID_FIELD, TRACE_ID_FIELD, DEVICES_FIELD, MATTER_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendConnectorEventRequest.memberNameToFieldInitializer();
    private final String connectorId;
    private final String userId;
    private final String operation;
    private final String operationVersion;
    private final Integer statusCode;
    private final String message;
    private final String deviceDiscoveryId;
    private final String connectorDeviceId;
    private final String traceId;
    private final List<Device> devices;
    private final MatterEndpoint matterEndpoint;

    private SendConnectorEventRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.userId = builder.userId;
        this.operation = builder.operation;
        this.operationVersion = builder.operationVersion;
        this.statusCode = builder.statusCode;
        this.message = builder.message;
        this.deviceDiscoveryId = builder.deviceDiscoveryId;
        this.connectorDeviceId = builder.connectorDeviceId;
        this.traceId = builder.traceId;
        this.devices = builder.devices;
        this.matterEndpoint = builder.matterEndpoint;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String userId() {
        return this.userId;
    }

    public final ConnectorEventOperation operation() {
        return ConnectorEventOperation.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final String operationVersion() {
        return this.operationVersion;
    }

    public final Integer statusCode() {
        return this.statusCode;
    }

    public final String message() {
        return this.message;
    }

    public final String deviceDiscoveryId() {
        return this.deviceDiscoveryId;
    }

    public final String connectorDeviceId() {
        return this.connectorDeviceId;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final boolean hasDevices() {
        return this.devices != null && !(this.devices instanceof SdkAutoConstructList);
    }

    public final List<Device> devices() {
        return this.devices;
    }

    public final MatterEndpoint matterEndpoint() {
        return this.matterEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevices() ? this.devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.matterEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendConnectorEventRequest)) {
            return false;
        }
        SendConnectorEventRequest other = (SendConnectorEventRequest)((Object)obj);
        return Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.operationVersion(), other.operationVersion()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.deviceDiscoveryId(), other.deviceDiscoveryId()) && Objects.equals(this.connectorDeviceId(), other.connectorDeviceId()) && Objects.equals(this.traceId(), other.traceId()) && this.hasDevices() == other.hasDevices() && Objects.equals(this.devices(), other.devices()) && Objects.equals(this.matterEndpoint(), other.matterEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"SendConnectorEventRequest").add("ConnectorId", (Object)this.connectorId()).add("UserId", (Object)(this.userId() == null ? null : "*** Sensitive Data Redacted ***")).add("Operation", (Object)this.operationAsString()).add("OperationVersion", (Object)(this.operationVersion() == null ? null : "*** Sensitive Data Redacted ***")).add("StatusCode", (Object)(this.statusCode() == null ? null : "*** Sensitive Data Redacted ***")).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("DeviceDiscoveryId", (Object)this.deviceDiscoveryId()).add("ConnectorDeviceId", (Object)(this.connectorDeviceId() == null ? null : "*** Sensitive Data Redacted ***")).add("TraceId", (Object)this.traceId()).add("Devices", this.hasDevices() ? this.devices() : null).add("MatterEndpoint", (Object)this.matterEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "OperationVersion": {
                return Optional.ofNullable(clazz.cast(this.operationVersion()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "DeviceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.deviceDiscoveryId()));
            }
            case "ConnectorDeviceId": {
                return Optional.ofNullable(clazz.cast(this.connectorDeviceId()));
            }
            case "TraceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "Devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
            case "MatterEndpoint": {
                return Optional.ofNullable(clazz.cast(this.matterEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("OperationVersion", OPERATION_VERSION_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("DeviceDiscoveryId", DEVICE_DISCOVERY_ID_FIELD);
        map.put("ConnectorDeviceId", CONNECTOR_DEVICE_ID_FIELD);
        map.put("TraceId", TRACE_ID_FIELD);
        map.put("Devices", DEVICES_FIELD);
        map.put("MatterEndpoint", MATTER_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendConnectorEventRequest, T> g) {
        return obj -> g.apply((SendConnectorEventRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String connectorId;
        private String userId;
        private String operation;
        private String operationVersion;
        private Integer statusCode;
        private String message;
        private String deviceDiscoveryId;
        private String connectorDeviceId;
        private String traceId;
        private List<Device> devices = DefaultSdkAutoConstructList.getInstance();
        private MatterEndpoint matterEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SendConnectorEventRequest model) {
            super(model);
            this.connectorId(model.connectorId);
            this.userId(model.userId);
            this.operation(model.operation);
            this.operationVersion(model.operationVersion);
            this.statusCode(model.statusCode);
            this.message(model.message);
            this.deviceDiscoveryId(model.deviceDiscoveryId);
            this.connectorDeviceId(model.connectorDeviceId);
            this.traceId(model.traceId);
            this.devices(model.devices);
            this.matterEndpoint(model.matterEndpoint);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(ConnectorEventOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getOperationVersion() {
            return this.operationVersion;
        }

        public final void setOperationVersion(String operationVersion) {
            this.operationVersion = operationVersion;
        }

        @Override
        public final Builder operationVersion(String operationVersion) {
            this.operationVersion = operationVersion;
            return this;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getDeviceDiscoveryId() {
            return this.deviceDiscoveryId;
        }

        public final void setDeviceDiscoveryId(String deviceDiscoveryId) {
            this.deviceDiscoveryId = deviceDiscoveryId;
        }

        @Override
        public final Builder deviceDiscoveryId(String deviceDiscoveryId) {
            this.deviceDiscoveryId = deviceDiscoveryId;
            return this;
        }

        public final String getConnectorDeviceId() {
            return this.connectorDeviceId;
        }

        public final void setConnectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
        }

        @Override
        public final Builder connectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
            return this;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final List<Device.Builder> getDevices() {
            List<Device.Builder> result = DevicesCopier.copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevices(Collection<Device.BuilderImpl> devices) {
            this.devices = DevicesCopier.copyFromBuilder(devices);
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = DevicesCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<Device.Builder> ... devices) {
            this.devices(Stream.of(devices).map(c -> (Device)((Device.Builder)Device.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MatterEndpoint.Builder getMatterEndpoint() {
            return this.matterEndpoint != null ? this.matterEndpoint.toBuilder() : null;
        }

        public final void setMatterEndpoint(MatterEndpoint.BuilderImpl matterEndpoint) {
            this.matterEndpoint = matterEndpoint != null ? matterEndpoint.build() : null;
        }

        @Override
        public final Builder matterEndpoint(MatterEndpoint matterEndpoint) {
            this.matterEndpoint = matterEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendConnectorEventRequest build() {
            return new SendConnectorEventRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendConnectorEventRequest> {
        public Builder connectorId(String var1);

        public Builder userId(String var1);

        public Builder operation(String var1);

        public Builder operation(ConnectorEventOperation var1);

        public Builder operationVersion(String var1);

        public Builder statusCode(Integer var1);

        public Builder message(String var1);

        public Builder deviceDiscoveryId(String var1);

        public Builder connectorDeviceId(String var1);

        public Builder traceId(String var1);

        public Builder devices(Collection<Device> var1);

        public Builder devices(Device ... var1);

        public Builder devices(Consumer<Device.Builder> ... var1);

        public Builder matterEndpoint(MatterEndpoint var1);

        default public Builder matterEndpoint(Consumer<MatterEndpoint.Builder> matterEndpoint) {
            return this.matterEndpoint((MatterEndpoint)((MatterEndpoint.Builder)MatterEndpoint.builder().applyMutation(matterEndpoint)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

